/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.InfObjEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.object.AnalogObject;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.IntegerUtil;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.TimeUtil;
import java.util.ArrayList;
import java.util.List;

public class InfObjCompAnalogExEntity
extends InfObjEntity {
    private int sysType = 0;
    private int sysAddress = 0;
    private int compType = 0;
    private int compCirc = 0;
    private int compNode = 0;
    private List<AnalogObject> analogs = new ArrayList<AnalogObject>();
    private String time = "2000-01-01 00:00:00";

    public static void decodeEntity(byte[] data, InfObjCompAnalogExEntity entity) {
        if (data.length < 14) {
            throw new ProtocolException("\u4fe1\u606f\u5bf9\u8c61\uff0c\u6700\u5c0f\u957f\u5ea6\u4e3a14");
        }
        int count = data[7] & 0xFF;
        if (data.length != 14 + count * 4) {
            throw new ProtocolException("\u4fe1\u606f\u5bf9\u8c61\uff0c\u957f\u5ea6=14" + count * 4);
        }
        int index = 0;
        entity.sysType = data[index++] & 0xFF;
        entity.sysAddress = data[index++] & 0xFF;
        entity.compType = data[index++] & 0xFF;
        entity.compCirc = IntegerUtil.decodeInteger2byte(data, index);
        entity.compNode = IntegerUtil.decodeInteger2byte(data, index += 2);
        index += 2;
        count = data[index++] & 0xFF;
        entity.analogs.clear();
        for (int i = 0; i < count; ++i) {
            AnalogObject analog = new AnalogObject();
            analog.setType(IntegerUtil.decodeInteger2byte(data, index));
            analog.setValue(IntegerUtil.decodeInteger2byte(data, index += 2));
            index += 2;
            entity.analogs.add(analog);
        }
        entity.time = TimeUtil.decodeTime6byte(data, index);
        index += 6;
    }

    public static byte[] encodeEntity(InfObjCompAnalogExEntity entity) {
        byte[] data = new byte[entity.size()];
        int index = 0;
        data[index++] = (byte)entity.sysType;
        data[index++] = (byte)entity.sysAddress;
        data[index++] = (byte)entity.compType;
        IntegerUtil.encodeInteger2byte(entity.compCirc, data, index);
        IntegerUtil.encodeInteger2byte(entity.compNode, data, index += 2);
        index += 2;
        data[index++] = (byte)entity.analogs.size();
        for (AnalogObject analog : entity.analogs) {
            IntegerUtil.encodeInteger2byte(analog.getType(), data, index);
            IntegerUtil.encodeInteger2byte(analog.getValue(), data, index += 2);
            index += 2;
        }
        TimeUtil.encodeTime6byte(entity.time, data, index);
        index += 6;
        return data;
    }

    public int size() {
        return 14 + 4 * this.analogs.size();
    }

    @Override
    public List<Integer> getAduSizes(byte[] data, int offset, int aduLength) {
        int count = data[offset + 1];
        ArrayList<Integer> aduList = new ArrayList<Integer>();
        int index = 2;
        for (int i = 0; i < count; ++i) {
            if (offset + (index += 7) >= data.length) {
                throw new ProtocolException("\u9a8c\u8bc1ADU\u7684\u957f\u5ea6\u4e0e\u5177\u4f53\u7684\u683c\u5f0f\uff0c\u4e0d\u5339\u914d");
            }
            byte ifCount = data[offset + index++];
            index += ifCount * 4;
            index += 6;
            aduList.add(14 + ifCount * 4);
        }
        if (aduLength != index) {
            throw new ProtocolException("\u9a8c\u8bc1ADU\u7684\u957f\u5ea6\u4e0e\u5177\u4f53\u7684\u683c\u5f0f\uff0c\u4e0d\u5339\u914d");
        }
        return aduList;
    }

    @Override
    public void decode(byte[] data) {
        InfObjCompAnalogExEntity.decodeEntity(data, this);
    }

    @Override
    public byte[] encode() {
        return InfObjCompAnalogExEntity.encodeEntity(this);
    }

    public int getSysType() {
        return this.sysType;
    }

    public int getSysAddress() {
        return this.sysAddress;
    }

    public int getCompType() {
        return this.compType;
    }

    public int getCompCirc() {
        return this.compCirc;
    }

    public int getCompNode() {
        return this.compNode;
    }

    public List<AnalogObject> getAnalogs() {
        return this.analogs;
    }

    public String getTime() {
        return this.time;
    }

    public void setSysType(int sysType) {
        this.sysType = sysType;
    }

    public void setSysAddress(int sysAddress) {
        this.sysAddress = sysAddress;
    }

    public void setCompType(int compType) {
        this.compType = compType;
    }

    public void setCompCirc(int compCirc) {
        this.compCirc = compCirc;
    }

    public void setCompNode(int compNode) {
        this.compNode = compNode;
    }

    public void setAnalogs(List<AnalogObject> analogs) {
        this.analogs = analogs;
    }

    public void setTime(String time) {
        this.time = time;
    }
}

