/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.AduEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.PduEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.TcpCtrlEntity;

public class TcpPduEntity
extends PduEntity {
    private TcpCtrlEntity ctrlEntity = new TcpCtrlEntity();
    private AduEntity aduEntity;

    public static int getSum(byte[] data, int offset, int length) {
        int sum = 0;
        for (int i = 0; i < length; ++i) {
            sum += data[offset + i] & 0xFF;
        }
        return sum;
    }

    public static byte[] encodeEntity(TcpPduEntity pduEntity) {
        byte[] aduData = pduEntity.aduEntity == null ? null : AduEntity.encodeEntity(pduEntity.aduEntity);
        int aduDataLength = aduData != null ? aduData.length : 0;
        pduEntity.ctrlEntity.setAduLength(aduDataLength);
        byte[] ctrlData = TcpCtrlEntity.encodeEntity(pduEntity.ctrlEntity);
        byte[] data = new byte[5 + ctrlData.length + aduDataLength];
        int index = 0;
        data[index++] = 64;
        data[index++] = 64;
        System.arraycopy(ctrlData, 0, data, index, ctrlData.length);
        index += ctrlData.length;
        if (aduData != null) {
            System.arraycopy(aduData, 0, data, index, aduData.length);
            index += aduData.length;
        }
        int sum = TcpPduEntity.getSum(data, 2, data.length - 5);
        data[index++] = (byte)sum;
        data[index++] = 35;
        data[index++] = 35;
        return data;
    }

    public static TcpPduEntity decodeEntity(byte[] data) {
        TcpPduEntity pduEntity = new TcpPduEntity();
        int pduSize = TcpPduEntity.getPduSize(data);
        int index = 2;
        TcpCtrlEntity ctrlEntity = pduEntity.getCtrlEntity();
        TcpCtrlEntity.decodeEntity(data, index, ctrlEntity);
        index += TcpCtrlEntity.size();
        if (ctrlEntity.getAduLength() == 0) {
            pduEntity.aduEntity = null;
            return pduEntity;
        }
        AduEntity aduEntity = new AduEntity();
        AduEntity.decodeEntity(data, index, ctrlEntity.getAduLength(), ctrlEntity.getCmd(), aduEntity);
        pduEntity.aduEntity = aduEntity;
        return pduEntity;
    }

    public static int getPduSize(byte[] data) {
        int lengthOffset;
        int aduLength;
        if (data.length < 5) {
            throw new ProtocolException("PDU\u7684\u957f\u5ea6\uff0c\u81f3\u5c115\u4e2a\u5b57\u8282");
        }
        int h = data[0] & 0xFF;
        int l = data[1] & 0xFF;
        if (h != 64 || l != 64) {
            throw new ProtocolException("\u8d77\u59cb\u7b26\u3002\u5fc5\u987b\u4e3a@@");
        }
        int ctrlLength = TcpCtrlEntity.size();
        if (data.length < 5 + ctrlLength + (aduLength = (h = data[2 + (lengthOffset = TcpCtrlEntity.getLengthOffset()) + 1] & 0xFF) * 256 + (l = data[2 + lengthOffset + 0] & 0xFF))) {
            throw new ProtocolException("PDU\u7684\u957f\u5ea6\uff0c\u4e0d\u5339\u914d");
        }
        h = data[3 + ctrlLength + aduLength] & 0xFF;
        l = data[4 + ctrlLength + aduLength] & 0xFF;
        if (h != 35 || l != 35) {
            throw new ProtocolException("\u7ed3\u675f\u7b26\u3002\u5fc5\u987b\u4e3a##");
        }
        int sum = TcpPduEntity.getSum(data, 2, ctrlLength + aduLength);
        if (data[2 + ctrlLength + aduLength] != (byte)sum) {
            throw new ProtocolException("\u6821\u9a8c\u548c\u4e0d\u6b63\u786e");
        }
        return ctrlLength + aduLength + 5;
    }

    @Override
    public int getSn() {
        return this.getCtrlEntity().getSn();
    }

    @Override
    public void setSn(int sn) {
        this.getCtrlEntity().setSn(sn);
    }

    public TcpCtrlEntity getCtrlEntity() {
        return this.ctrlEntity;
    }

    public AduEntity getAduEntity() {
        return this.aduEntity;
    }

    public void setCtrlEntity(TcpCtrlEntity ctrlEntity) {
        this.ctrlEntity = ctrlEntity;
    }

    public void setAduEntity(AduEntity aduEntity) {
        this.aduEntity = aduEntity;
    }
}

