/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.CtrlEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.AddressUtil;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.IntegerUtil;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.TimeUtil;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.VersionUtil;

public class TcpCtrlEntity
extends CtrlEntity {
    private int sn = 0;
    private String protocolVersion = "1.00";
    private String time = "2000-01-01 00:00:00";
    private String srcAddr = "FFFFFFFFFFFF";
    private String dstAddr = "FFFFFFFFFFFF";
    private int aduLength = 0;
    private int cmd = 0;

    public static int size() {
        return 25;
    }

    public static int getLengthOffset() {
        return TcpCtrlEntity.size() - 3;
    }

    public static byte[] encodeEntity(TcpCtrlEntity entity) {
        byte[] data = new byte[TcpCtrlEntity.size()];
        int index = 0;
        IntegerUtil.encodeInteger2byte(entity.sn, data, index);
        VersionUtil.encodeVersion2byte(entity.protocolVersion, data, index += 2);
        TimeUtil.encodeTime6byte(entity.time, data, index += 2);
        AddressUtil.encodeAddress6byte(entity.srcAddr, data, index += 6);
        AddressUtil.encodeAddress6byte(entity.dstAddr, data, index += 6);
        IntegerUtil.encodeInteger2byte(entity.aduLength, data, index += 6);
        index += 2;
        data[index++] = (byte)entity.cmd;
        return data;
    }

    public static void decodeEntity(byte[] data, int offset, TcpCtrlEntity entity) {
        if (data.length < TcpCtrlEntity.size() + offset) {
            throw new ProtocolException("\u63a7\u5236\u5355\u5143\uff0c\u56fa\u5b9a\u957f\u5ea6\u4e3a25");
        }
        int index = offset;
        entity.sn = IntegerUtil.decodeInteger2byte(data, index);
        entity.protocolVersion = VersionUtil.decodeVersion2byte(data, index += 2);
        entity.time = TimeUtil.decodeTime6byte(data, index += 2);
        entity.srcAddr = AddressUtil.decodeAddress6byte(data, index += 6);
        entity.dstAddr = AddressUtil.decodeAddress6byte(data, index += 6);
        entity.aduLength = IntegerUtil.decodeInteger2byte(data, index += 6);
        index += 2;
        entity.cmd = data[index++] & 0xFF;
    }

    public void bind(TcpCtrlEntity other) {
        this.sn = other.sn;
        this.protocolVersion = other.protocolVersion;
        this.time = other.time;
        this.srcAddr = other.srcAddr;
        this.dstAddr = other.dstAddr;
        this.aduLength = other.aduLength;
        this.cmd = other.cmd;
    }

    public void swapAddr() {
        String tmp = this.dstAddr;
        this.dstAddr = this.srcAddr;
        this.srcAddr = tmp;
    }

    public int getSn() {
        return this.sn;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getTime() {
        return this.time;
    }

    public String getSrcAddr() {
        return this.srcAddr;
    }

    public String getDstAddr() {
        return this.dstAddr;
    }

    @Override
    public int getAduLength() {
        return this.aduLength;
    }

    @Override
    public int getCmd() {
        return this.cmd;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setSrcAddr(String srcAddr) {
        this.srcAddr = srcAddr;
    }

    public void setDstAddr(String dstAddr) {
        this.dstAddr = dstAddr;
    }

    @Override
    public void setAduLength(int aduLength) {
        this.aduLength = aduLength;
    }

    @Override
    public void setCmd(int cmd) {
        this.cmd = cmd;
    }
}

