/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.AduEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.CoapCtrlEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.PduEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.IntegerUtil;

public class CoapPduEntity
extends PduEntity {
    private int sn = 0;
    private CoapCtrlEntity ctrlEntity = new CoapCtrlEntity();
    private AduEntity aduEntity;

    public static int getSum(byte[] data, int offset, int length) {
        int sum = 0;
        for (int i = 0; i < length; ++i) {
            sum += data[offset + i] & 0xFF;
        }
        return sum;
    }

    public static byte[] encodeEntity(CoapPduEntity pduEntity) {
        byte[] aduData = pduEntity.aduEntity == null ? null : AduEntity.encodeEntity(pduEntity.aduEntity);
        int aduDataLength = aduData != null ? aduData.length : 0;
        pduEntity.ctrlEntity.setAduLength(aduDataLength);
        byte[] ctrlData = CoapCtrlEntity.encodeEntity(pduEntity.ctrlEntity);
        byte[] data = new byte[5 + ctrlData.length + aduDataLength];
        int index = 0;
        IntegerUtil.encodeInteger2byte(pduEntity.sn, data, index);
        IntegerUtil.encodeInteger2byte(ctrlData.length + aduDataLength + 1, data, index += 2);
        System.arraycopy(ctrlData, 0, data, index += 2, ctrlData.length);
        index += ctrlData.length;
        if (aduData != null) {
            System.arraycopy(aduData, 0, data, index, aduData.length);
            index += aduData.length;
        }
        int sum = CoapPduEntity.getSum(data, 4, ctrlData.length + aduDataLength);
        data[index++] = (byte)sum;
        return data;
    }

    public static CoapPduEntity decodeEntity(byte[] data) {
        CoapPduEntity pduEntity = new CoapPduEntity();
        int pduSize = CoapPduEntity.getPduSize(data);
        int index = 4;
        CoapCtrlEntity ctrlEntity = pduEntity.getCtrlEntity();
        CoapCtrlEntity.decodeEntity(data, index, ctrlEntity);
        index += CoapCtrlEntity.size();
        if (ctrlEntity.getAduLength() == 0) {
            pduEntity.aduEntity = null;
            return pduEntity;
        }
        AduEntity aduEntity = new AduEntity();
        AduEntity.decodeEntity(data, index, ctrlEntity.getAduLength(), ctrlEntity.getCmd(), aduEntity);
        pduEntity.aduEntity = aduEntity;
        return pduEntity;
    }

    public static int getPduSize(byte[] data) {
        if (data.length < 5) {
            throw new ProtocolException("PDU\u7684\u957f\u5ea6\uff0c\u81f3\u5c115\u4e2a\u5b57\u8282");
        }
        int length = IntegerUtil.decodeInteger2byte(data, 2);
        if (data.length != 4 + length) {
            throw new ProtocolException("PDU\u7684\u957f\u5ea6\uff0c\u4e0d\u5339\u914d");
        }
        int sum = CoapPduEntity.getSum(data, 4, length - 1);
        if (data[3 + length] != (byte)sum) {
            throw new ProtocolException("\u6821\u9a8c\u548c\u4e0d\u6b63\u786e");
        }
        return length + 5;
    }

    @Override
    public int getSn() {
        return this.sn;
    }

    public CoapCtrlEntity getCtrlEntity() {
        return this.ctrlEntity;
    }

    public AduEntity getAduEntity() {
        return this.aduEntity;
    }

    @Override
    public void setSn(int sn) {
        this.sn = sn;
    }

    public void setCtrlEntity(CoapCtrlEntity ctrlEntity) {
        this.ctrlEntity = ctrlEntity;
    }

    public void setAduEntity(AduEntity aduEntity) {
        this.aduEntity = aduEntity;
    }
}

