/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.CtrlEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.IntegerUtil;

public class CoapCtrlEntity
extends CtrlEntity {
    private int aduLength = 0;
    private int cmd = 0;

    public static int size() {
        return 3;
    }

    public static int getLengthOffset() {
        return 0;
    }

    public static byte[] encodeEntity(CoapCtrlEntity entity) {
        byte[] data = new byte[CoapCtrlEntity.size()];
        int index = 0;
        IntegerUtil.encodeInteger2byte(entity.aduLength, data, index);
        index += 2;
        data[index++] = (byte)entity.cmd;
        return data;
    }

    public static void decodeEntity(byte[] data, int offset, CoapCtrlEntity entity) {
        if (data.length < CoapCtrlEntity.size() + offset) {
            throw new ProtocolException("\u63a7\u5236\u5355\u5143\uff0c\u56fa\u5b9a\u957f\u5ea6\u4e3a3");
        }
        int index = offset;
        entity.aduLength = IntegerUtil.decodeInteger2byte(data, index);
        index += 2;
        entity.cmd = data[index++] & 0xFF;
    }

    @Override
    public int getAduLength() {
        return this.aduLength;
    }

    @Override
    public int getCmd() {
        return this.cmd;
    }

    @Override
    public void setAduLength(int aduLength) {
        this.aduLength = aduLength;
    }

    @Override
    public void setCmd(int cmd) {
        this.cmd = cmd;
    }
}

