/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.AduInfObjMap;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.InfObjEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.enums.AduType;
import java.util.ArrayList;
import java.util.List;

public class AduEntity {
    private int type = 0;
    private List<InfObjEntity> infObjEntities = new ArrayList<InfObjEntity>();

    public static byte[] encodeEntity(AduEntity aduEntity) {
        int length = 2;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (InfObjEntity infObjEntity : aduEntity.infObjEntities) {
            byte[] data = infObjEntity.encode();
            length += data.length;
            list.add(data);
        }
        byte[] data = new byte[length];
        int index = 0;
        data[index++] = (byte)aduEntity.type;
        data[index++] = (byte)aduEntity.infObjEntities.size();
        for (byte[] item : list) {
            System.arraycopy(item, 0, data, index, item.length);
            index += item.length;
        }
        return data;
    }

    public static void decodeEntity(byte[] data, int offset, int aduLength, int cmd, AduEntity aduEntity) {
        int type;
        if (data.length - offset < 2) {
            throw new ProtocolException("ADU\u7684\u957f\u5ea6\uff0c\u81f3\u5c112\u4e2a\u5b57\u8282");
        }
        int index = offset;
        aduEntity.type = type = data[index++] & 0xFF;
        int count = data[index++] & 0xFF;
        Class clazz = AduInfObjMap.getInfObjClass(AduType.getEnum(aduEntity.type));
        if (clazz == null) {
            throw new ProtocolException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u6807\u8bc6" + String.format("%02X", aduEntity.type));
        }
        aduEntity.infObjEntities.clear();
        if (count < 1) {
            return;
        }
        try {
            InfObjEntity entity = (InfObjEntity)clazz.newInstance();
            List<Integer> aduSizes = entity.getAduSizes(data, offset, aduLength);
            for (Integer aduSize : aduSizes) {
                byte[] item = new byte[aduSize.intValue()];
                System.arraycopy(data, index, item, 0, item.length);
                index += item.length;
                entity = (InfObjEntity)clazz.newInstance();
                entity.decode(item);
                aduEntity.infObjEntities.add(entity);
            }
        }
        catch (Exception e) {
            throw new ProtocolException("\u89e3\u7801\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public int getType() {
        return this.type;
    }

    public List<InfObjEntity> getInfObjEntities() {
        return this.infObjEntities;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setInfObjEntities(List<InfObjEntity> infObjEntities) {
        this.infObjEntities = infObjEntities;
    }
}

