/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.core.worker;

import cn.foxtech.device.protocol.v1.core.channel.FoxEdgeChannelService;
import cn.foxtech.device.protocol.v1.core.enums.WorkerLoggerType;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.method.FoxEdgeMethodTemplate;
import cn.foxtech.device.protocol.v1.core.method.FoxEdgePublishMethod;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.naming.CommunicationException;

public class FoxEdgePublishWorker {
    public static void publish(String deviceName, String manufacturer, String deviceType, String operateName, Map<String, Object> params, int timeout, FoxEdgeChannelService channelService) throws ProtocolException, CommunicationException {
        try {
            Map<String, Object> methodPairs = FoxEdgeMethodTemplate.inst().getPublishMethod(manufacturer, deviceType);
            if (methodPairs == null) {
                throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u8bbe\u5907\u7c7b\u578b\u7684\u7f16\u7801\u5668\uff1a" + manufacturer + ":" + deviceType);
            }
            Map methodMap = (Map)methodPairs.get(operateName);
            if (methodMap == null) {
                throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u7f16\u7801/\u89e3\u7801\u51fd\u6570\uff1a" + operateName);
            }
            FoxEdgePublishMethod methodPair = (FoxEdgePublishMethod)methodMap.get("method");
            if (methodPair == null) {
                throw new ProtocolException("\u6570\u636e\u7ed3\u6784\u5f02\u5e38!");
            }
            if (methodPair == null) {
                throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u7f16\u7801\u51fd\u6570\uff1a" + operateName);
            }
            if (methodPair.getEncoderMethod() == null) {
                throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u7f16\u7801\u51fd\u6570\uff1a" + operateName);
            }
            if (timeout <= 0) {
                timeout = methodPair.getTimeout();
            }
            Object send = methodPair.getEncoderMethod().invoke(null, params);
            channelService.printLogger(deviceName, manufacturer, deviceType, WorkerLoggerType.send, send);
            try {
                channelService.publish(deviceName, deviceType, send, timeout);
            }
            catch (Exception e) {
                throw new CommunicationException(e.getMessage());
            }
        }
        catch (InvocationTargetException ie) {
            throw new ProtocolException(ie.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage());
        }
    }
}

