/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.core.template;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.template.ITemplate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TemplateContainer {
    private final Map<String, ITemplate> sysTemplate = new ConcurrentHashMap<String, ITemplate>();
    private final Map<String, Object> userTemplate = new ConcurrentHashMap<String, Object>();

    public static TemplateContainer newInstance() {
        return new TemplateContainer();
    }

    public <T> ITemplate getSysTemplateInfo(Class<T> clazz) {
        ITemplate templateInstance = this.sysTemplate.get(clazz.getSimpleName());
        if (templateInstance == null) {
            try {
                templateInstance = (ITemplate)clazz.newInstance();
                this.sysTemplate.put(clazz.getSimpleName(), templateInstance);
                return templateInstance;
            }
            catch (Exception e) {
                throw new ProtocolException("\u5b9e\u4f8b\u5316\u6a21\u677f\u5bf9\u8c61\u5931\u8d25:" + clazz.getSimpleName());
            }
        }
        return templateInstance;
    }

    public <T> ITemplate newTemplateInstance(Class<T> clazz) {
        try {
            return (ITemplate)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ProtocolException("\u5b9e\u4f8b\u5316\u6a21\u677f\u5bf9\u8c61\u5931\u8d25:" + clazz.getSimpleName());
        }
    }

    public <T> T getTemplate(String sourceType, String templateName, Class<T> clazz) {
        ITemplate template;
        if (!ITemplate.class.isAssignableFrom(clazz)) {
            throw new ProtocolException("\u8fd9\u4e0d\u662fITemplate\u7684\u6d3e\u751f\u7c7b\u578b:" + clazz.getSimpleName());
        }
        ITemplate sysTemplateInfo = this.getSysTemplateInfo(clazz);
        ConcurrentHashMap<String, ITemplate> template4operate = (ConcurrentHashMap<String, ITemplate>)this.userTemplate.get(sysTemplateInfo.getSysTemplateName());
        if (template4operate == null) {
            template4operate = new ConcurrentHashMap<String, ITemplate>();
            this.userTemplate.put(sysTemplateInfo.getSysTemplateName(), template4operate);
        }
        if ((template = (ITemplate)template4operate.get(templateName)) == null) {
            template = this.newTemplateInstance(clazz);
            template.loadJsnModel(templateName);
            template4operate.put(templateName, template);
        }
        if (sourceType.equals("jsn")) {
            template.loadJsnModel(templateName);
        }
        if (clazz.isInstance(template)) {
            return (T)template;
        }
        return null;
    }
}

