/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.core.worker;

import cn.foxtech.device.protocol.core.channel.FoxEdgeChannelService;
import cn.foxtech.device.protocol.core.exception.ProtocolException;
import cn.foxtech.device.protocol.core.method.FoxEdgeMethodTemplate;
import cn.foxtech.device.protocol.core.method.FoxEdgePublishMethod;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.naming.CommunicationException;

public class FoxEdgePublishWorker {
    public static void publish(String deviceName, String deviceType, String operateName, Map<String, Object> params, int timeout, FoxEdgeChannelService channelService) throws ProtocolException, CommunicationException {
        try {
            Map<String, FoxEdgePublishMethod> methodPairs = FoxEdgeMethodTemplate.inst().getPublishMethod().get(deviceType);
            if (methodPairs == null) {
                throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u8bbe\u5907\u7c7b\u578b\u7684\u7f16\u7801\u5668\uff1a" + deviceType);
            }
            FoxEdgePublishMethod methodPair = methodPairs.get(operateName);
            if (methodPair == null) {
                throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u7f16\u7801\u51fd\u6570\uff1a" + operateName);
            }
            if (methodPair.getEncoderMethod() == null) {
                throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u7f16\u7801\u51fd\u6570\uff1a" + operateName);
            }
            if (timeout <= 0) {
                timeout = methodPair.getTimeout();
            }
            Object send = methodPair.getEncoderMethod().invoke(null, params);
            try {
                channelService.publish(deviceName, deviceType, send, timeout);
            }
            catch (Exception e) {
                throw new CommunicationException(e.getMessage());
            }
        }
        catch (InvocationTargetException ie) {
            throw new ProtocolException(ie.getTargetException().getMessage());
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage());
        }
    }
}

