/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;

public class JsonUtils {
    public static <T1, T2> T2 buildObject(T1 value, Class<T2> valueType) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsn = objectMapper.writeValueAsString(value);
        return (T2)objectMapper.readValue(jsn, valueType);
    }

    public static <T> T buildObject(String value, Class<T> valueType) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (T)objectMapper.readValue(value, valueType);
    }

    public static <T> T buildObject(Map map, Class<T> valueType) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsn = objectMapper.writeValueAsString((Object)map);
        return (T)objectMapper.readValue(jsn, valueType);
    }

    public static <T> T buildObjectWithoutException(Map map, Class<T> valueType) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String jsn = objectMapper.writeValueAsString((Object)map);
            return (T)objectMapper.readValue(jsn, valueType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> String buildJson(T value) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString(value);
        return json;
    }

    public static <T> String buildJsonWithoutException(T value) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString(value);
            return json;
        }
        catch (Exception e) {
            return null;
        }
    }
}

