/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.core.utils;

public class BcdUtils {
    public static byte[] str2bcd(String bcd) {
        int size = bcd.length() / 2;
        int remainder = bcd.length() % 2;
        byte[] bcdByte = new byte[size + remainder];
        for (int i = 0; i < size; ++i) {
            int low = Integer.parseInt(bcd.substring(2 * i, 2 * i + 1));
            int high = Integer.parseInt(bcd.substring(2 * i + 1, 2 * i + 2));
            bcdByte[i] = (byte)(high << 4 | low);
        }
        if (remainder > 0) {
            int low = Integer.parseInt(bcd.substring(bcd.length() - 1));
            bcdByte[bcdByte.length - 1] = (byte)(0xF0 | low);
        }
        return bcdByte;
    }

    public static String bcd2str(byte[] bcd) {
        if (null == bcd || bcd.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bcd.length; ++i) {
            int low = bcd[i] & 0xF;
            sb.append(low);
            int high = (bcd[i] & 0xF0) >> 4;
            if (high == 15) continue;
            sb.append(high);
        }
        return sb.toString();
    }

    public static int bcd2int(byte bcd) {
        return ((bcd & 0xF0) >> 4) * 10 + (bcd & 0xF);
    }
}

