/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.cjt188.core;

import cn.foxtech.device.protocol.v1.cjt188.core.CJT188Entity;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;

public class CJT188ProtocolFrame {
    public static byte[] encodePack(CJT188Entity entity) {
        byte[] pack = new byte[entity.getData().length + 16];
        pack[0] = -2;
        pack[1] = -2;
        pack[2] = -2;
        pack[3] = 104;
        pack[4] = (byte)entity.getType().getValue();
        String address = entity.getAddress().getValue().replace(" ", "");
        if (address == null || address.length() != 14) {
            throw new ProtocolException("\u5730\u5740\u7801\u957f\u5ea6\u4e0d\u6b63\u786e\uff0c\u5e94\u8be5\u662f14\u5b57\u8282\u957f\u5ea6\u7684BCD\u683c\u5f0f\u6587\u672c\u5b57\u7b26\u4e32");
        }
        pack[5] = (byte)CJT188ProtocolFrame.encodeBcd(address.charAt(0), address.charAt(1));
        pack[6] = (byte)CJT188ProtocolFrame.encodeBcd(address.charAt(2), address.charAt(3));
        pack[7] = (byte)CJT188ProtocolFrame.encodeBcd(address.charAt(4), address.charAt(5));
        pack[8] = (byte)CJT188ProtocolFrame.encodeBcd(address.charAt(6), address.charAt(7));
        pack[9] = (byte)CJT188ProtocolFrame.encodeBcd(address.charAt(8), address.charAt(9));
        pack[10] = (byte)CJT188ProtocolFrame.encodeBcd(address.charAt(10), address.charAt(11));
        pack[11] = (byte)CJT188ProtocolFrame.encodeBcd(address.charAt(12), address.charAt(13));
        pack[12] = (byte)entity.getCtrl().getValue();
        pack[13] = (byte)entity.getData().length;
        System.arraycopy(entity.getData(), 0, pack, 14, entity.getData().length);
        int check = CJT188ProtocolFrame.getCheck(pack, 3, entity.getData().length + 15);
        pack[pack.length - 2] = (byte)check;
        pack[pack.length - 1] = 22;
        return pack;
    }

    public static CJT188Entity decodePack(byte[] pack) {
        if (pack.length < 16) {
            throw new ProtocolException("\u62a5\u6587\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
        }
        int start = -1;
        for (int i = 0; i < pack.length; ++i) {
            if (pack[i] == -2) continue;
            if (pack[i] != 104) {
                throw new ProtocolException("\u8d77\u59cb\u7b26\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u7684\u683c\u5f0f\u4e3aFE FE FE 68");
            }
            start = i;
            break;
        }
        if (start == -1) {
            throw new ProtocolException("\u8d77\u59cb\u7b26\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u7684\u683c\u5f0f\u4e3aFE FE FE 68");
        }
        if (pack.length != start + 13 + (pack[start + 10] & 0xFF)) {
            throw new ProtocolException("\u62a5\u6587\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
        }
        CJT188Entity entity = new CJT188Entity();
        entity.getType().setValue(pack[start + 1] & 0xFF);
        StringBuilder sb = new StringBuilder();
        CJT188ProtocolFrame.decodeBcd(pack[start + 2], sb);
        CJT188ProtocolFrame.decodeBcd(pack[start + 3], sb);
        CJT188ProtocolFrame.decodeBcd(pack[start + 4], sb);
        CJT188ProtocolFrame.decodeBcd(pack[start + 5], sb);
        CJT188ProtocolFrame.decodeBcd(pack[start + 6], sb);
        CJT188ProtocolFrame.decodeBcd(pack[start + 7], sb);
        CJT188ProtocolFrame.decodeBcd(pack[start + 8], sb);
        String address = sb.toString();
        entity.getAddress().setValue(address);
        entity.getCtrl().setValue(pack[start + 9] & 0xFF);
        int len = pack[start + 10] & 0xFF;
        byte[] data = new byte[len];
        entity.setData(data);
        System.arraycopy(pack, start + 11, entity.getData(), 0, len);
        byte check = (byte)CJT188ProtocolFrame.getCheck(pack, start, pack.length - 2);
        if (check != pack[pack.length - 2]) {
            throw new ProtocolException("\u68c0\u9a8c\u7801\u4e0d\u6b63\u786e\uff01");
        }
        if (pack[pack.length - 1] != 22) {
            throw new ProtocolException("\u7ed3\u675f\u7b26\u4e0d\u6b63\u786e\uff01");
        }
        return entity;
    }

    private static int getCheck(byte[] pack, int start, int end) {
        int check = 0;
        for (int i = start; i < end; ++i) {
            check += pack[i] & 0xFF;
        }
        return check &= 0xFF;
    }

    public static int encodeBcd(char ch, char cl) {
        int value = 0;
        if ('0' <= ch && ch <= '9') {
            value += ch - 48 << 4;
        } else if ('a' <= ch && ch <= 'f') {
            value += (ch - 97 << 4) + 160;
        } else if ('A' <= ch && ch <= 'F') {
            value += (ch - 65 << 4) + 160;
        } else {
            throw new ProtocolException("\u5730\u5740\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u8be5\u662f0~10\uff0cA~F\u7684\u5b57\u7b26!");
        }
        if ('0' <= cl && cl <= '9') {
            value += cl - 48;
        } else if ('a' <= cl && cl <= 'f') {
            value += cl - 97 + 10;
        } else if ('A' <= cl && cl <= 'F') {
            value += cl - 65 + 10;
        } else {
            throw new ProtocolException("\u5730\u5740\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u8be5\u662f0~10\uff0cA~F\u7684\u5b57\u7b26!");
        }
        return value;
    }

    private static void decodeBcd(byte by, StringBuilder sb) {
        int ch = by & 0xF0;
        int cl = by & 0xF;
        if (0 <= ch && ch <= 144) {
            sb.append((char)((ch >> 4) + 48));
        } else if (160 <= ch && ch <= 240) {
            sb.append((char)((ch >> 4) - 10 + 65));
        } else if (160 <= ch && ch <= 240) {
            sb.append((char)((ch >> 4) - 10 + 65));
        } else {
            throw new ProtocolException("\u5730\u5740\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u8be5\u662f0~10\uff0cA~F\u7684\u5b57\u7b26!");
        }
        if (0 <= cl && cl <= 9) {
            sb.append((char)(cl + 48));
        } else if (10 <= cl && cl <= 15) {
            sb.append((char)(cl - 10 + 65));
        } else if (10 <= cl && cl <= 15) {
            sb.append((char)(cl - 10 + 65));
        } else {
            throw new ProtocolException("\u5730\u5740\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u8be5\u662f0~10\uff0cA~F\u7684\u5b57\u7b26!");
        }
    }
}

