/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.cetups;

import cn.foxtech.device.protocol.cetups.CETUPSProtocolFrame;
import cn.foxtech.device.protocol.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.core.utils.HexUtils;
import cn.foxtech.device.protocol.modbus.core.ModBusReadRegistersRequest;
import java.util.Map;

@FoxEdgeDeviceType(value="CE+T UPS", manufacturer="\u6df1\u5733\u5b89\u5723\u7535\u6c14\u6709\u9650\u516c\u53f8")
public class CETUPSProtocolGetSystemMeasures
extends CETUPSProtocolFrame {
    @FoxEdgeOperate(name="Read System Measures Table", polling=true, type="encoder", timeout=2000)
    public static String packCmdGetSystemMeasures(Map<String, Object> param) {
        CETUPSProtocolFrame.pretreatParam(param);
        ModBusReadRegistersRequest request = new ModBusReadRegistersRequest();
        request.setMemAddr(1070);
        request.setCount(69);
        return HexUtils.byteArrayToHexString((byte[])CETUPSProtocolFrame.protocol.packCmdReadHoldingRegisters4Request(request));
    }

    @FoxEdgeOperate(name="Read System Measures Table", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> unPackCmdGetSystemMeasures(String hexString, Map<String, Object> param) {
        byte[] arrCmd = HexUtils.hexStringToByteArray((String)hexString);
        Map value = CETUPSProtocolFrame.protocol.unPackCmdReadHoldingRegisters2Map(arrCmd);
        if (value == null) {
            return null;
        }
        byte byAddr = (Byte)value.get("ADDR");
        int[] arrStatus = (int[])value.get("REG_HOLD_STATUS");
        if (byAddr != 1) {
            return null;
        }
        if (arrStatus.length != 69) {
            return null;
        }
        int index = 0;
        value.put("\u7cfb\u7edf\u8f93\u51fa\u7535\u538b", arrStatus[index++]);
        value.put("\u7cfb\u7edf\u8f93\u51fa\u7535\u6d41", Float.valueOf((float)arrStatus[index++] / 10.0f));
        value.put("\u7cfb\u7edf\u8f93\u51fa\u529f\u7387", arrStatus[index++]);
        value.put("\u7cfb\u7edf\u8f93\u51fa\u9891\u7387", Float.valueOf((float)arrStatus[index++] / 10.0f));
        value.put("\u8d1f\u8f7d\u6bd4", arrStatus[index++]);
        value.put("\u7ec41\u8f93\u5165\u7535\u538b", Float.valueOf((float)arrStatus[index++] / 10.0f));
        value.put("\u7ec42\u8f93\u5165\u7535\u538b", Float.valueOf((float)arrStatus[index++] / 10.0f));
        value.put("\u7ec43\u8f93\u5165\u7535\u538b", Float.valueOf((float)arrStatus[index++] / 10.0f));
        value.put("\u7ec44\u8f93\u5165\u7535\u538b", Float.valueOf((float)arrStatus[index++] / 10.0f));
        ++index;
        for (int i = 0; i < 16; ++i) {
            value.put(String.format("\u9006\u53d8\u5668%02d\u8f93\u51fa\u7535\u6d41", i + 1), arrStatus[index++] / 10);
            value.put(String.format("\u9006\u53d8\u5668%02d\u8f93\u51fa\u529f\u7387", i + 1), arrStatus[index++]);
            value.put(String.format("\u9006\u53d8\u5668%02d\u6e29\u5ea6", i + 1), arrStatus[index++]);
        }
        value.remove("REG_HOLD_STATUS");
        return value;
    }
}

