/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.bass260zj;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeReport;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.utils.FoxEdgeUtils;
import cn.foxtech.device.protocol.v1.telecom.core.TelecomEntity;
import cn.foxtech.device.protocol.v1.telecom.core.TelecomProtocol;
import cn.foxtech.device.protocol.v1.utils.BcdUtils;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FoxEdgeDeviceType(value="BASS260ZJ", manufacturer="\u5e7f\u4e1c\u9ad8\u65b0\u5174")
public class BASS260ZJGetCardRecord
extends TelecomProtocol {
    @FoxEdgeOperate(name="\u8bfb\u53d6\u5237\u5361\u8bb0\u5f55", polling=true, type="encoder", mode="record", timeout=2000)
    public static String packCmdGetCardRecord(Map<String, Object> param) {
        TelecomEntity entity = new TelecomEntity();
        entity.setVer((byte)16);
        entity.setAddr((byte)1);
        entity.setCID1((byte)-128);
        entity.setCID2((byte)74);
        byte[] data = new byte[]{-14, -30, 0};
        entity.setData(data);
        byte[] arrCmd = BASS260ZJGetCardRecord.packCmd4Entity((TelecomEntity)entity);
        return HexUtils.byteArrayToHexString((byte[])arrCmd);
    }

    @FoxEdgeReport(type="alarm")
    @FoxEdgeOperate(name="\u8bfb\u53d6\u5237\u5361\u8bb0\u5f55", polling=true, type="decoder", mode="record", timeout=2000)
    public static List<Map<String, Object>> unPackCmdGetCardRecord(String hexString, Map<String, Object> param) {
        byte[] arrCmd = HexUtils.hexStringToByteArray((String)hexString);
        TelecomEntity entity = BASS260ZJGetCardRecord.unPackCmd2Entity((byte[])arrCmd);
        byte[] dat = entity.getData();
        if (dat.length != 14) {
            throw new ProtocolException("\u8fd4\u56de\u7684data\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
        }
        byte[] card = new byte[4];
        for (int i = 0; i < 4; ++i) {
            card[i] = dat[i + 1];
        }
        String cardID = HexUtils.byteArrayToHexString((byte[])card).replace(" ", "");
        byte[] time = new byte[7];
        for (int i = 0; i < 7; ++i) {
            time[i] = dat[i + 5];
        }
        String datetime = String.format("%02d%02d-%02d-%02d %02d:%02d:%02d", BcdUtils.bcd2int((byte)time[0]), BcdUtils.bcd2int((byte)time[1]), BcdUtils.bcd2int((byte)time[2]), BcdUtils.bcd2int((byte)time[3]), BcdUtils.bcd2int((byte)time[4]), BcdUtils.bcd2int((byte)time[5]), BcdUtils.bcd2int((byte)time[6]));
        byte byStatus = dat[12];
        byte byRemark = dat[13];
        String event = BASS260ZJGetCardRecord.unPackRemark(byStatus, byRemark);
        HashMap<String, String> record = new HashMap<String, String>();
        record.put("cardId", cardID);
        record.put("datetime", datetime);
        record.put("event", event);
        ArrayList<HashMap<String, String>> dataList = new ArrayList<HashMap<String, String>>();
        dataList.add(record);
        return FoxEdgeUtils.makeRecordTypeTag((String)"\u5237\u5361\u8bb0\u5f55", dataList);
    }

    private static String unPackRemark(byte dwStatus, byte dwRemark) {
        if ((dwRemark & 0x7F) == 0) {
            if ((dwStatus & 4) == 0) {
                return "\u5237\u5361\u8fdb\u95e8";
            }
            return "\u5237\u5361\u51fa\u95e8";
        }
        if ((dwRemark & 0x7F) == 2) {
            return "\u8fdc\u7a0b\u5f00\u95e8";
        }
        if ((dwRemark & 0x7F) == 3) {
            return "\u65e0\u6548\u6570\u636e";
        }
        if ((dwRemark & 0x7F) == 8) {
            return "\u975e\u6cd5\u95e8\u7981\u5361\u5237\u5361";
        }
        if ((dwRemark & 0x7F) == 9) {
            return "\u8fc7\u671f\u95e8\u7981\u5361\u5237\u5361";
        }
        if ((dwRemark & 0x7F) == 10) {
            return "\u9650\u671f\u95e8\u7981\u5361\u5237\u5361";
        }
        if ((dwRemark & 0x7F) == 11) {
            return "\u975e\u6cd5\u5f00\u95e8";
        }
        if ((dwRemark & 0x7F) == 12) {
            return "\u975e\u6cd5\u79bb\u5f00";
        }
        if ((dwRemark & 0x7F) == 13) {
            return "\u79bb\u5f00\u672a\u5173\u95e8";
        }
        return "";
    }
}

