/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.link.common.scheduler;

import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.entity.entity.LinkEntity;
import cn.foxtech.common.entity.manager.RedisConsoleService;
import cn.foxtech.common.utils.DifferUtils;
import cn.foxtech.common.utils.scheduler.singletask.PeriodTaskService;
import cn.foxtech.link.common.api.LinkClientAPI;
import cn.foxtech.link.common.properties.LinkProperties;
import cn.foxtech.link.common.service.EntityManageService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkRedisScheduler
extends PeriodTaskService {
    private static final Logger logger = Logger.getLogger(LinkRedisScheduler.class);
    @Autowired
    private EntityManageService entityManageService;
    @Autowired
    private LinkClientAPI linkService;
    @Autowired
    private LinkProperties linkProperties;
    private Map<String, LinkEntity> linkEntityMap;
    @Autowired
    private RedisConsoleService console;

    public void execute(long threadId) throws Exception {
        Thread.sleep(1000L);
        this.entityManageService.syncEntity();
        this.syncLinkConfig();
    }

    private void syncLinkConfig() {
        String message;
        LinkEntity linkEntity;
        String linkType = this.linkProperties.getLinkType();
        Long updateTime = this.entityManageService.removeReloadedFlag(LinkEntity.class.getSimpleName());
        if (updateTime == null && this.linkEntityMap != null) {
            return;
        }
        List entityList = this.entityManageService.getLinkEntity(linkType);
        HashMap<String, LinkEntity> map = new HashMap<String, LinkEntity>();
        for (BaseEntity entity : entityList) {
            LinkEntity linkEntity2 = (LinkEntity)entity;
            map.put(linkEntity2.getLinkName(), linkEntity2);
        }
        if (this.linkEntityMap == null) {
            this.linkEntityMap = new HashMap<String, LinkEntity>();
        }
        HashSet addList = new HashSet();
        HashSet delList = new HashSet();
        HashSet eqlList = new HashSet();
        DifferUtils.differByValue(this.linkEntityMap.keySet(), map.keySet(), addList, delList, eqlList);
        for (String key : addList) {
            try {
                linkEntity = (LinkEntity)map.get(key);
                this.linkService.openLink(linkEntity.getLinkName(), linkEntity.getLinkParam());
                this.linkEntityMap.put(key, linkEntity);
                message = "\u94fe\u8def\u6253\u5f00\u6210\u529f:" + key;
                this.console.info(message);
                logger.info((Object)message);
            }
            catch (Exception e) {
                message = "\u94fe\u8def\u6253\u5f00\u5931\u8d25:" + key + ":" + e.getMessage();
                this.console.error(message);
                logger.error((Object)message);
            }
        }
        for (String key : delList) {
            try {
                linkEntity = this.linkEntityMap.get(key);
                this.linkService.closeLink(linkEntity.getLinkName(), linkEntity.getLinkParam());
                this.linkEntityMap.remove(key);
                message = "\u94fe\u8def\u5173\u95ed\u6210\u529f:" + key;
                this.console.info(message);
                logger.info((Object)message);
            }
            catch (Exception e) {
                message = "\u94fe\u8def\u5173\u95ed\u5931\u8d25:" + key + ":" + e.getMessage();
                this.console.error(message);
                logger.error((Object)message);
            }
        }
        for (String key : eqlList) {
            try {
                LinkEntity oldEntity = this.linkEntityMap.get(key);
                LinkEntity newEntity = (LinkEntity)map.get(key);
                String newValue = newEntity.makeServiceValue();
                String oldValue = oldEntity.makeServiceValue();
                if (newValue.equals(oldValue)) continue;
                this.linkService.closeLink(oldEntity.getLinkName(), oldEntity.getLinkParam());
                this.linkEntityMap.remove(key);
                this.linkService.openLink(newEntity.getLinkName(), newEntity.getLinkParam());
                this.linkEntityMap.put(key, newEntity);
                String message2 = "\u94fe\u8def\u91cd\u7f6e\u6210\u529f:" + key;
                this.console.info(message2);
                logger.info((Object)message2);
            }
            catch (Exception e) {
                message = "\u94fe\u8def\u91cd\u7f6e\u5931\u8d25:" + key + ":" + e.getMessage();
                this.console.error(message);
                logger.error((Object)message);
            }
        }
    }
}

