/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.link.common.service;

import cn.foxtech.common.entity.manager.RedisConsoleService;
import cn.foxtech.common.utils.json.JsonUtils;
import cn.foxtech.common.utils.redis.topic.service.RedisTopicSubscriber;
import cn.foxtech.common.utils.syncobject.SyncQueueObjectMap;
import cn.foxtech.link.common.api.LinkClientAPI;
import cn.foxtech.link.common.properties.LinkProperties;
import cn.foxtech.link.domain.LinkBaseVO;
import cn.foxtech.link.domain.LinkRequestVO;
import cn.foxtech.link.domain.LinkRespondVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisTopicSuberService
extends RedisTopicSubscriber {
    @Autowired
    private RedisConsoleService logger;
    @Autowired
    private LinkClientAPI linkService;
    @Autowired
    private LinkProperties linkProperties;

    public String topic1st() {
        return "topic_link_request_" + this.linkProperties.getLinkType();
    }

    public void receiveTopic1st(String message) {
        try {
            LinkRequestVO requestVO = (LinkRequestVO)JsonUtils.buildObject((String)message, LinkRequestVO.class);
            if (LinkRequestVO.MODE_MANAGE.equals(requestVO.getMode())) {
                LinkRespondVO respondVO = this.manage(requestVO);
                respondVO.setUuid(requestVO.getUuid());
                respondVO.setType(this.linkProperties.getLinkType());
                String json = JsonUtils.buildJson((Object)respondVO);
                SyncQueueObjectMap.inst().push("topic_link_respond_manager", (Object)json, 10);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    private LinkRespondVO manage(LinkRequestVO requestVO) {
        try {
            return this.linkService.manageLink(requestVO);
        }
        catch (Exception e) {
            return LinkRespondVO.error((LinkBaseVO)requestVO, (String)("publish \u64cd\u4f5c\u5931\u8d25\uff1a" + e));
        }
    }
}

