/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.iot.common.remote;

import cn.foxtech.common.entity.manager.LocalConfigService;
import cn.foxtech.iot.common.remote.RemoteHttpProxyService;
import cn.foxtech.iot.common.remote.RemoteMqttService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoteProxyService {
    @Autowired
    private LocalConfigService localConfigService;
    @Autowired
    private RemoteHttpProxyService httpProxyService;
    @Autowired
    private RemoteMqttService mqttService;
    private String mode;

    public void initialize() {
        Map configs = this.localConfigService.getConfig();
        Map remote = configs.getOrDefault("remote", new HashMap());
        this.mode = remote.getOrDefault("mode", "http");
        if ("http".equals(this.mode)) {
            Map http = remote.getOrDefault("http", new HashMap());
            String host = http.getOrDefault("host", "http://localhost");
            this.httpProxyService.setUri(host);
        }
        if ("mqtt".equals(this.mode)) {
            Map mqtt = remote.getOrDefault("mqtt", new HashMap());
            this.mqttService.setMqttConfig(mqtt);
        }
    }

    public LocalConfigService getLocalConfigService() {
        return this.localConfigService;
    }

    public RemoteHttpProxyService getHttpProxyService() {
        return this.httpProxyService;
    }

    public RemoteMqttService getMqttService() {
        return this.mqttService;
    }

    public String getMode() {
        return this.mode;
    }
}

