/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.script.engine;

import cn.foxtech.common.utils.MapUtils;
import cn.foxtech.device.protocol.v1.core.context.ApplicationContext;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import cn.foxtech.device.script.engine.ScriptEngineService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScriptEngineModel {
    private final Map<String, Object> modelMap = new ConcurrentHashMap<String, Object>();
    @Autowired
    private ScriptEngineService engineService;

    public synchronized void setEnvDeviceModel(String manufacturer, String deviceType, String modelNameKey, Map<String, Object> params) {
        try {
            Long engineUpdateTime;
            Long globalUpdateTime;
            ScriptEngine scriptEngine = this.engineService.getScriptEngine(manufacturer, deviceType);
            if (MethodUtils.hasEmpty((Object[])new Object[]{modelNameKey})) {
                return;
            }
            String modelName = (String)params.get(modelNameKey);
            if (MethodUtils.hasEmpty((Object[])new Object[]{modelName})) {
                return;
            }
            Map globalModel = ApplicationContext.getDeviceModels((String)modelName);
            if (MethodUtils.hasEmpty((Map)globalModel, (Object[])new Object[0])) {
                return;
            }
            Map engineModel = (Map)MapUtils.getValue(this.modelMap, (Object[])new Object[]{manufacturer, deviceType, modelName});
            if (engineModel != null && ((Object)(globalUpdateTime = globalModel.getOrDefault("updateTime", 0L))).equals(engineUpdateTime = engineModel.getOrDefault("updateTime", 0L))) {
                return;
            }
            engineModel = globalModel;
            MapUtils.setValue(this.modelMap, (Object[])new Object[]{manufacturer, deviceType, modelName, engineModel});
            Map<String, Object> deviceModels = this.buildEngineModels(manufacturer, deviceType);
            scriptEngine.put("fox_edge_model", deviceModels);
        }
        catch (Exception e) {
            return;
        }
    }

    private Map<String, Object> buildEngineModels(String manufacturer, String deviceType) {
        Map engineModels = (Map)MapUtils.getValue(this.modelMap, (Object[])new Object[]{manufacturer, deviceType});
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : engineModels.keySet()) {
            List list;
            Map engineModel = (Map)engineModels.get(key);
            Map modelParam = (Map)engineModel.get("modelParam");
            if (modelParam == null || (list = (List)modelParam.get("list")) == null) continue;
            result.put(key, list);
        }
        return result;
    }
}

