/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.script.engine;

import cn.foxtech.common.entity.entity.OperateEntity;
import cn.foxtech.common.utils.method.MethodUtils;
import cn.foxtech.device.protocol.v1.core.channel.FoxEdgeChannelService;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.script.engine.ScriptEngineModel;
import cn.foxtech.device.script.engine.ScriptEngineOperator;
import cn.foxtech.device.script.engine.ScriptEngineService;
import java.util.HashMap;
import java.util.Map;
import javax.naming.CommunicationException;
import javax.script.ScriptEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PublishService {
    @Autowired
    private ScriptEngineService engineService;
    @Autowired
    private ScriptEngineOperator engineOperator;
    @Autowired
    private ScriptEngineModel engineModel;

    public void publish(String deviceName, String manufacturer, String deviceType, OperateEntity operateEntity, Map<String, Object> params, int timeout, FoxEdgeChannelService channelService) throws ProtocolException {
        try {
            Object send;
            ScriptEngine engine = this.engineService.getScriptEngine(manufacturer, deviceType);
            String modelName = operateEntity.getEngineParam().getOrDefault("modelName", "");
            Map encode = operateEntity.getEngineParam().getOrDefault("encode", new HashMap());
            if (MethodUtils.hasEmpty((Object[])new Object[]{encode})) {
                throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u7f16\u7801\u51fd\u6570\uff1a" + operateEntity.getOperateName());
            }
            String encodeMain = encode.getOrDefault("main", "");
            String encodeScript = encode.getOrDefault("code", "");
            if (MethodUtils.hasEmpty((Object[])new Object[]{encodeMain, encodeScript})) {
                throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u7f16\u7801\u51fd\u6570\uff1a" + operateEntity.getOperateName());
            }
            try {
                this.engineModel.setEnvDeviceModel(manufacturer, deviceType, modelName, params);
                this.engineOperator.setSendEnvValue(engine, params);
                send = this.engineOperator.encode(engine, encodeMain, encodeScript);
            }
            catch (Exception e) {
                throw new ProtocolException("\u7f16\u7801\u9519\u8bef\uff1a" + e.getMessage());
            }
            try {
                channelService.publish(deviceName, deviceType, send, timeout);
            }
            catch (Exception e) {
                throw new CommunicationException(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage());
        }
    }
}

