/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.script.engine;

import cn.foxtech.common.entity.entity.OperateEntity;
import cn.foxtech.common.utils.method.MethodUtils;
import cn.foxtech.device.protocol.v1.core.channel.FoxEdgeChannelService;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.script.engine.ScriptEngineModel;
import cn.foxtech.device.script.engine.ScriptEngineOperator;
import cn.foxtech.device.script.engine.ScriptEngineService;
import java.util.HashMap;
import java.util.Map;
import javax.naming.CommunicationException;
import javax.script.ScriptEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExchangeService {
    @Autowired
    private ScriptEngineService engineService;
    @Autowired
    private ScriptEngineOperator engineOperator;
    @Autowired
    private ScriptEngineModel engineModel;

    public Map<String, Object> exchange(String deviceName, String manufacturer, String deviceType, OperateEntity operateEntity, Map<String, Object> params, int timeout, FoxEdgeChannelService channelService) throws ProtocolException {
        Object recv;
        Object send;
        ScriptEngine engine = this.engineService.getScriptEngine(manufacturer, deviceType);
        String modelName = operateEntity.getEngineParam().getOrDefault("modelName", "");
        Map encode = operateEntity.getEngineParam().getOrDefault("encode", new HashMap());
        Map decode = operateEntity.getEngineParam().getOrDefault("decode", new HashMap());
        if (MethodUtils.hasEmpty((Object[])new Object[]{encode, decode})) {
            throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u7f16\u7801/\u89e3\u7801\u51fd\u6570\uff1a" + operateEntity.getOperateName());
        }
        String encodeMain = encode.getOrDefault("main", "");
        String encodeScript = encode.getOrDefault("code", "");
        if (MethodUtils.hasEmpty((Object[])new Object[]{encodeMain, encodeScript})) {
            throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u7f16\u7801\u51fd\u6570\uff1a" + operateEntity.getOperateName());
        }
        String decodeMain = decode.getOrDefault("main", "");
        String decodeScript = decode.getOrDefault("code", "");
        if (MethodUtils.hasEmpty((Object[])new Object[]{decodeMain, decodeScript})) {
            throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u89e3\u7801\u51fd\u6570\uff1a" + operateEntity.getOperateName());
        }
        try {
            this.engineModel.setEnvDeviceModel(manufacturer, deviceType, modelName, params);
            this.engineOperator.setSendEnvValue(engine, params);
            send = this.engineOperator.encode(engine, encodeMain, encodeScript);
        }
        catch (Exception e) {
            throw new ProtocolException("\u7f16\u7801\u9519\u8bef\uff1a" + e.getMessage());
        }
        try {
            recv = channelService.exchange(deviceName, deviceType, send, timeout);
        }
        catch (Exception e) {
            throw new CommunicationException(e.getMessage());
        }
        try {
            this.engineOperator.setRecvEnvValue(engine, recv, params);
            if ("record".equals(operateEntity.getDataType())) {
                return this.engineOperator.decodeRecord(engine, operateEntity.getOperateName(), decodeMain, decodeScript);
            }
            if ("result".equals(operateEntity.getDataType())) {
                return this.engineOperator.decodeResult(engine, operateEntity.getOperateName(), decodeMain, decodeScript);
            }
            return this.engineOperator.decodeStatus(engine, operateEntity.getOperateName(), decodeMain, decodeScript);
        }
        catch (Exception e) {
            try {
                throw new ProtocolException("\u89e3\u7801\u9519\u8bef\uff1a" + e.getMessage());
            }
            catch (Exception e2) {
                throw new ProtocolException(e2.getMessage());
            }
        }
    }
}

