/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.script.engine;

import cn.foxtech.common.entity.manager.InitialConfigService;
import cn.foxtech.common.utils.json.JsonUtils;
import cn.foxtech.core.exception.ServiceException;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScriptEngineOperator {
    @Autowired
    private InitialConfigService configService;

    public void setSendEnvValue(ScriptEngine engine, Map<String, Object> params) {
        try {
            engine.put("fox_edge_param", JsonUtils.buildJson(params));
        }
        catch (Exception e) {
            this.printLogger(e.getMessage());
            throw new ProtocolException(e.getMessage());
        }
    }

    public void setRecvEnvValue(ScriptEngine engine, Object recv, Map<String, Object> params) {
        try {
            engine.put("fox_edge_param", JsonUtils.buildJson(params));
            if (recv instanceof Map) {
                engine.put("fox_edge_data", JsonUtils.buildJson((Object)recv));
                return;
            }
            if (recv instanceof List) {
                engine.put("fox_edge_data", JsonUtils.buildJson((Object)recv));
                return;
            }
            if (recv instanceof String) {
                engine.put("fox_edge_data", recv);
                return;
            }
            throw new ServiceException("\u5bf9\u901a\u9053\u8fd4\u56de\u7684\u6570\u636e\uff0c\u53ea\u652f\u6301String\u3001Map\u3001List\u4e09\u79cd\u6570\u636e\u7ed3\u6784\uff01");
        }
        catch (Exception e) {
            this.printLogger(e.getMessage());
            throw new ProtocolException(e.getMessage());
        }
    }

    public Map<String, Object> decodeRecord(ScriptEngine engine, String operateName, String decodeMain, String decodeScript) {
        try {
            engine.eval(decodeScript);
            Object data = engine.eval(decodeMain + "();");
            List values = (List)JsonUtils.buildObject((String)((String)data), List.class);
            HashMap<String, List> recordValue = new HashMap<String, List>();
            recordValue.put("record", values);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("operateName", operateName);
            result.put("data", recordValue);
            return result;
        }
        catch (InvalidFormatException e) {
            throw new ProtocolException(e.getMessage());
        }
        catch (MismatchedInputException e) {
            throw new ProtocolException(e.getMessage());
        }
        catch (Exception e) {
            this.printLogger(e.getMessage());
            throw new ProtocolException(e.getMessage());
        }
    }

    public Map<String, Object> decodeStatus(ScriptEngine engine, String operateName, String decodeMain, String decodeScript) {
        try {
            engine.eval(decodeScript);
            Object data = engine.eval(decodeMain + "();");
            Map values = (Map)JsonUtils.buildObject((String)((String)data), Map.class);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("status", values);
            return result;
        }
        catch (InvalidFormatException ife) {
            throw new ProtocolException(ife.getMessage());
        }
        catch (MismatchedInputException mie) {
            throw new ProtocolException(mie.getMessage());
        }
        catch (Exception e) {
            this.printLogger(e.getMessage());
            throw new ProtocolException(e.getMessage());
        }
    }

    public Map<String, Object> decodeResult(ScriptEngine engine, String operateName, String decodeMain, String decodeScript) {
        try {
            engine.eval(decodeScript);
            Object data = engine.eval(decodeMain + "();");
            Map values = (Map)JsonUtils.buildObject((String)((String)data), Map.class);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("operateName", operateName);
            result.put("result", values);
            return result;
        }
        catch (InvalidFormatException ife) {
            throw new ProtocolException(ife.getMessage());
        }
        catch (MismatchedInputException mie) {
            throw new ProtocolException(mie.getMessage());
        }
        catch (Exception e) {
            this.printLogger(e.getMessage());
            throw new ProtocolException(e.getMessage());
        }
    }

    public Object encode(ScriptEngine engine, String encodeMain, String encodeScript) {
        try {
            engine.eval(encodeScript);
            String out = (String)engine.eval(encodeMain + "();");
            if (out == null) {
                throw new ProtocolException("\u7f16\u7801\u9519\u8bef\uff1a\u8f93\u51fa\u4e3anull");
            }
            if (out.startsWith("{") && out.endsWith("}")) {
                return JsonUtils.buildObject((String)out, Map.class);
            }
            if (out.startsWith("[") && out.endsWith("[}]")) {
                return JsonUtils.buildObject((String)out, List.class);
            }
            return out;
        }
        catch (Exception e) {
            this.printLogger(e.getMessage());
            throw new ServiceException(e.getMessage());
        }
    }

    private void printLogger(Object recv) {
        if (recv == null) {
            return;
        }
        if (!Boolean.TRUE.equals(this.configService.getConfigParam("serverConfig").get("logger"))) {
            return;
        }
        this.configService.getLogger().info(recv.toString());
    }
}

