/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.script.engine;

import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.entity.entity.OperateEntity;
import cn.foxtech.common.entity.manager.RedisConsoleService;
import cn.foxtech.common.entity.service.redis.BaseConsumerTypeNotify;
import cn.foxtech.common.utils.method.MethodUtils;
import cn.foxtech.device.script.engine.ScriptEngineService;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperateNotify
implements BaseConsumerTypeNotify {
    private static final Logger logger = Logger.getLogger(OperateNotify.class);
    @Autowired
    private RedisConsoleService console;
    @Autowired
    private ScriptEngineService engineService;

    public void notify(String entityType, long updateTime, Map<String, BaseEntity> addMap, Set<String> delSet, Map<String, BaseEntity> mdyMap) {
        for (String key : addMap.keySet()) {
            this.rebindScriptEngine(addMap.get(key));
        }
        for (String key : mdyMap.keySet()) {
            this.rebindScriptEngine(mdyMap.get(key));
        }
        for (String string : delSet) {
        }
    }

    public void rebindScriptEngine(BaseEntity entity) {
        try {
            OperateEntity operateEntity = (OperateEntity)entity;
            if (!operateEntity.getEngineType().equals("JavaScript")) {
                return;
            }
            if (!operateEntity.getServiceType().equals("device")) {
                return;
            }
            ScriptEngine engine = this.engineService.getScriptEngine(operateEntity.getManufacturer(), operateEntity.getDeviceType());
            if (operateEntity.getOperateMode().equals("include")) {
                Map include = (Map)operateEntity.getEngineParam().get("include");
                if (!MethodUtils.hasEmpty((Object[])new Object[]{include})) {
                    String jsp = (String)include.get("code");
                    engine.eval(jsp);
                }
            } else {
                Map decode = (Map)operateEntity.getEngineParam().get("decode");
                if (!MethodUtils.hasEmpty((Object[])new Object[]{decode})) {
                    String jsp = (String)decode.get("code");
                    engine.eval(jsp);
                }
                Map encode = (Map)operateEntity.getEngineParam().get("encode");
                if (!MethodUtils.hasEmpty((Object[])new Object[]{encode})) {
                    String jsp = (String)encode.get("code");
                    engine.eval(jsp);
                }
            }
        }
        catch (Exception e) {
            String message = "\u521d\u59cb\u5316\u811a\u672c\u5f15\u64ce\u5f02\u5e38\uff1a" + entity.makeServiceKey() + "; " + e.getMessage();
            logger.error((Object)message);
            this.console.error(message);
        }
    }
}

