/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.script.engine;

import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.entity.entity.OperateEntity;
import cn.foxtech.common.entity.manager.InitialConfigService;
import cn.foxtech.common.utils.method.MethodUtils;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.script.engine.ScriptEngineOperator;
import cn.foxtech.device.script.engine.ScriptEngineService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportService {
    @Autowired
    private InitialConfigService configService;
    @Autowired
    private ScriptEngineService engineService;
    @Autowired
    private ScriptEngineOperator engineOperator;

    public Map<String, Object> decode(String manufacturer, String deviceType, List<BaseEntity> jspReportList, Object recv, Map<String, Object> params) throws ProtocolException {
        this.printLogger("\u63a5\u6536\u5230\u901a\u9053\u4e0a\u62a5\u6570\u636e\uff1a" + recv);
        ScriptEngine engine = this.engineService.getScriptEngine(manufacturer, deviceType);
        for (BaseEntity entity : jspReportList) {
            OperateEntity operateEntity = (OperateEntity)entity;
            try {
                Map decode = operateEntity.getEngineParam().getOrDefault("decode", new HashMap());
                if (MethodUtils.hasEmpty((Object[])new Object[]{decode})) {
                    throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u89e3\u7801\u51fd\u6570\uff1a" + operateEntity.getOperateName());
                }
                String decodeMain = decode.getOrDefault("main", "");
                String decodeScript = decode.getOrDefault("code", "");
                if (MethodUtils.hasEmpty((Object[])new Object[]{decodeMain, decodeScript})) {
                    throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u64cd\u4f5c\u540d\u79f0\u7684\u89e3\u7801\u51fd\u6570\uff1a" + operateEntity.getOperateName());
                }
                this.engineOperator.setRecvEnvValue(engine, recv, params);
                if ("record".equals(operateEntity.getDataType())) {
                    return this.engineOperator.decodeRecord(engine, operateEntity.getOperateName(), decodeMain, decodeScript);
                }
                return this.engineOperator.decodeStatus(engine, operateEntity.getOperateName(), decodeMain, decodeScript);
            }
            catch (Exception e) {
                this.printLogger("\u89e3\u7801\u5931\u8d25:" + operateEntity.toString() + "\r\n" + e.getMessage());
            }
        }
        throw new ProtocolException("\u627e\u4e0d\u5230\u5bf9\u5e94\u8bbe\u5907\u7c7b\u578b\u7684\u89e3\u7801\u5668\uff1a" + manufacturer + ":" + deviceType);
    }

    private void printLogger(Object recv) {
        if (recv == null) {
            return;
        }
        if (!Boolean.TRUE.equals(this.configService.getConfigParam("serverConfig").get("logger"))) {
            return;
        }
        this.configService.getLogger().info(recv.toString());
    }
}

