/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.scanner;

import cn.foxtech.common.utils.MapUtils;
import cn.foxtech.common.utils.reflect.JarLoaderUtils;
import cn.foxtech.device.protocol.RootLocation;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperateParam;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeReport;
import cn.foxtech.device.protocol.v1.core.method.FoxEdgeReportMethod;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FoxEdgeReportScanner {
    public static Map<String, Object> scanMethodPair(String pack) {
        HashMap<String, Object> manufacturerMap = new HashMap<String, Object>();
        try {
            Set classSet = JarLoaderUtils.getClasses((String)pack);
            for (Class aClass : classSet) {
                if (!aClass.isAnnotationPresent(FoxEdgeDeviceType.class)) continue;
                URL url = aClass.getProtectionDomain().getCodeSource().getLocation();
                String filePath = url.getPath();
                FoxEdgeDeviceType typeAnnotation = aClass.getAnnotation(FoxEdgeDeviceType.class);
                String deviceType = typeAnnotation.value();
                String manufacturer = typeAnnotation.manufacturer();
                Map<String, FoxEdgeReportMethod> methodMap = FoxEdgeReportScanner.scanMethodPair(manufacturer, deviceType, aClass);
                for (String method : methodMap.keySet()) {
                    MapUtils.setValue(manufacturerMap, (Object[])new Object[]{manufacturer, deviceType, method, "method", methodMap.get(method)});
                    MapUtils.setValue(manufacturerMap, (Object[])new Object[]{manufacturer, deviceType, method, "file", filePath});
                }
            }
        }
        catch (Throwable e) {
            e.getCause();
            e.printStackTrace();
        }
        return manufacturerMap;
    }

    public static Map<String, FoxEdgeReportMethod> scanMethodPair(String manufacturer, String deviceType, Class<?> aClass) {
        Method[] methods;
        HashMap<String, FoxEdgeReportMethod> operater2methodpair = new HashMap<String, FoxEdgeReportMethod>();
        for (Method method : methods = aClass.getMethods()) {
            FoxEdgeOperate operAnnotation;
            if (!method.isAnnotationPresent(FoxEdgeOperate.class) || !method.isAnnotationPresent(FoxEdgeReport.class) || !"decoder".equals((operAnnotation = method.getAnnotation(FoxEdgeOperate.class)).type())) continue;
            FoxEdgeReportMethod methodPair = (FoxEdgeReportMethod)operater2methodpair.get(operAnnotation.name());
            if (methodPair == null) {
                methodPair = new FoxEdgeReportMethod();
                operater2methodpair.put(operAnnotation.name(), methodPair);
            }
            FoxEdgeReport eventAnnotation = method.getAnnotation(FoxEdgeReport.class);
            Map<String, String> params = FoxEdgeReportScanner.getFoxEdgeMethodParam(method.getAnnotation(FoxEdgeOperateParam.class));
            methodPair.setManufacturer(manufacturer);
            methodPair.setDeviceType(deviceType);
            methodPair.setName(operAnnotation.name());
            methodPair.setMode(operAnnotation.mode());
            methodPair.setType(eventAnnotation.type());
            methodPair.setDecoderMethod(method);
        }
        return operater2methodpair;
    }

    public static Map<String, Object> scanMethodPair() {
        return FoxEdgeReportScanner.scanMethodPair(RootLocation.class.getPackage().getName());
    }

    private static Map<String, String> getFoxEdgeMethodParam(FoxEdgeOperateParam paramAnnotation) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (paramAnnotation == null) {
            return params;
        }
        for (int i = 0; i < paramAnnotation.names().length; ++i) {
            String paramName = paramAnnotation.names()[i];
            String paramValue = "";
            if (i < paramAnnotation.values().length) {
                paramValue = paramAnnotation.values()[i];
            }
            params.put(paramName, paramValue);
        }
        return params;
    }
}

