/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.scanner;

import cn.foxtech.common.utils.MapUtils;
import cn.foxtech.common.utils.reflect.JarLoaderUtils;
import cn.foxtech.device.protocol.RootLocation;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperateParam;
import cn.foxtech.device.protocol.v1.core.method.FoxEdgeExchangeMethod;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FoxEdgeExchangeScanner {
    private static final Logger logger = Logger.getLogger(FoxEdgeExchangeScanner.class);

    public static Map<String, Object> scanMethodPair(String pack) {
        HashMap<String, Object> manufacturerMap = new HashMap<String, Object>();
        try {
            Set classSet = JarLoaderUtils.getClasses((String)pack);
            for (Class aClass : classSet) {
                String name = aClass.getName();
                if (!aClass.isAnnotationPresent(FoxEdgeDeviceType.class)) continue;
                URL url = aClass.getProtectionDomain().getCodeSource().getLocation();
                String filePath = url.getPath();
                FoxEdgeDeviceType typeAnnotation = aClass.getAnnotation(FoxEdgeDeviceType.class);
                String deviceType = typeAnnotation.value();
                String manufacturer = typeAnnotation.manufacturer();
                Map<String, FoxEdgeExchangeMethod> methodMap = FoxEdgeExchangeScanner.scanMethodPair(manufacturer, deviceType, aClass);
                for (String method : methodMap.keySet()) {
                    MapUtils.setValue(manufacturerMap, (Object[])new Object[]{manufacturer, deviceType, method, "method", methodMap.get(method)});
                    MapUtils.setValue(manufacturerMap, (Object[])new Object[]{manufacturer, deviceType, method, "file", filePath});
                }
            }
        }
        catch (Throwable e) {
            e.getCause();
            e.printStackTrace();
        }
        return manufacturerMap;
    }

    public static Map<String, FoxEdgeExchangeMethod> scanMethodPair(String manufacturer, String deviceType, Class<?> aClass) {
        HashMap<String, FoxEdgeExchangeMethod> operater2methodpair = new HashMap<String, FoxEdgeExchangeMethod>();
        try {
            if (!aClass.isAnnotationPresent(FoxEdgeDeviceType.class)) {
                return operater2methodpair;
            }
            Method[] methods = aClass.getMethods();
            for (Method method : methods) {
                if (!method.isAnnotationPresent(FoxEdgeOperate.class)) continue;
                FoxEdgeOperate operAnnotation = method.getAnnotation(FoxEdgeOperate.class);
                FoxEdgeExchangeMethod methodPair = (FoxEdgeExchangeMethod)operater2methodpair.get(operAnnotation.name());
                if (methodPair == null) {
                    methodPair = new FoxEdgeExchangeMethod();
                    operater2methodpair.put(operAnnotation.name(), methodPair);
                }
                Map<String, String> params = FoxEdgeExchangeScanner.getFoxEdgeMethodParam(method.getAnnotation(FoxEdgeOperateParam.class));
                methodPair.setManufacturer(manufacturer);
                methodPair.setDeviceType(deviceType);
                methodPair.setName(operAnnotation.name());
                methodPair.setPolling(operAnnotation.polling());
                if ("encoder".equals(operAnnotation.type())) {
                    methodPair.setEncoderMethod(method);
                    methodPair.setEncoderParams(params);
                }
                if (!"decoder".equals(operAnnotation.type())) continue;
                methodPair.setTimeout(Integer.valueOf(operAnnotation.timeout()));
                methodPair.setDecoderMethod(method);
                methodPair.setDecoderParams(params);
                methodPair.setMode(operAnnotation.mode());
            }
        }
        catch (Throwable e) {
            e.getCause();
            e.printStackTrace();
        }
        HashMap<String, FoxEdgeExchangeMethod> result = new HashMap<String, FoxEdgeExchangeMethod>();
        for (Map.Entry entry : operater2methodpair.entrySet()) {
            FoxEdgeExchangeMethod operateMethod = (FoxEdgeExchangeMethod)entry.getValue();
            if (operateMethod.getDecoderMethod() == null || operateMethod.getEncoderMethod() == null) continue;
            result.put((String)entry.getKey(), (FoxEdgeExchangeMethod)entry.getValue());
        }
        return result;
    }

    public static Map<String, Object> scanMethodPair() {
        return FoxEdgeExchangeScanner.scanMethodPair(RootLocation.class.getPackage().getName());
    }

    private static Map<String, String> getFoxEdgeMethodParam(FoxEdgeOperateParam paramAnnotation) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (paramAnnotation == null) {
            return params;
        }
        for (int i = 0; i < paramAnnotation.names().length; ++i) {
            String paramName = paramAnnotation.names()[i];
            String paramValue = "";
            if (i < paramAnnotation.values().length) {
                paramValue = paramAnnotation.values()[i];
            }
            params.put(paramName, paramValue);
        }
        return params;
    }
}

