/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.scanner;

import cn.foxtech.common.utils.MapUtils;
import cn.foxtech.common.utils.reflect.JarLoaderUtils;
import cn.foxtech.device.protocol.RootLocation;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperateParam;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgePublish;
import cn.foxtech.device.protocol.v1.core.method.FoxEdgePublishMethod;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FoxEdgePublishScanner {
    public static Map<String, Object> scanMethodPair(String pack) {
        HashMap<String, Object> manufacturerMap = new HashMap<String, Object>();
        HashMap deviceType2operater = new HashMap();
        try {
            Set classSet = JarLoaderUtils.getClasses((String)pack);
            for (Class aClass : classSet) {
                if (!aClass.isAnnotationPresent(FoxEdgeDeviceType.class)) continue;
                URL url = aClass.getProtectionDomain().getCodeSource().getLocation();
                String filePath = url.getPath();
                FoxEdgeDeviceType typeAnnotation = aClass.getAnnotation(FoxEdgeDeviceType.class);
                String deviceType = typeAnnotation.value();
                String manufacturer = typeAnnotation.manufacturer();
                Map<String, FoxEdgePublishMethod> methodMap = FoxEdgePublishScanner.scanMethodPair(manufacturer, deviceType, aClass);
                for (String method : methodMap.keySet()) {
                    MapUtils.setValue(manufacturerMap, (Object[])new Object[]{manufacturer, deviceType, method, "method", methodMap.get(method)});
                    MapUtils.setValue(manufacturerMap, (Object[])new Object[]{manufacturer, deviceType, method, "file", filePath});
                }
            }
        }
        catch (Throwable e) {
            e.getCause();
            e.printStackTrace();
        }
        return manufacturerMap;
    }

    public static Map<String, FoxEdgePublishMethod> scanMethodPair(String manufacturer, String deviceType, Class<?> aClass) {
        HashMap<String, FoxEdgePublishMethod> operater2methodpair = new HashMap<String, FoxEdgePublishMethod>();
        try {
            Method[] methods;
            if (!aClass.isAnnotationPresent(FoxEdgeDeviceType.class)) {
                return operater2methodpair;
            }
            for (Method method : methods = aClass.getMethods()) {
                FoxEdgeOperate operAnnotation;
                if (!method.isAnnotationPresent(FoxEdgeOperate.class) || !method.isAnnotationPresent(FoxEdgePublish.class) || !"encoder".equals((operAnnotation = method.getAnnotation(FoxEdgeOperate.class)).type())) continue;
                FoxEdgePublishMethod methodPair = (FoxEdgePublishMethod)operater2methodpair.get(operAnnotation.name());
                if (methodPair == null) {
                    methodPair = new FoxEdgePublishMethod();
                    operater2methodpair.put(operAnnotation.name(), methodPair);
                }
                Map<String, String> params = FoxEdgePublishScanner.getFoxEdgeMethodParam(method.getAnnotation(FoxEdgeOperateParam.class));
                methodPair.setManufacturer(manufacturer);
                methodPair.setDeviceType(deviceType);
                methodPair.setName(operAnnotation.name());
                methodPair.setPolling(operAnnotation.polling());
                methodPair.setEncoderMethod(method);
                methodPair.setEncoderParams(params);
            }
        }
        catch (Throwable e) {
            e.getCause();
            e.printStackTrace();
        }
        return operater2methodpair;
    }

    public static Map<String, Object> scanMethodPair() {
        return FoxEdgePublishScanner.scanMethodPair(RootLocation.class.getPackage().getName());
    }

    private static Map<String, String> getFoxEdgeMethodParam(FoxEdgeOperateParam paramAnnotation) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (paramAnnotation == null) {
            return params;
        }
        for (int i = 0; i < paramAnnotation.names().length; ++i) {
            String paramName = paramAnnotation.names()[i];
            String paramValue = "";
            if (i < paramAnnotation.values().length) {
                paramValue = paramAnnotation.values()[i];
            }
            params.put(paramName, paramValue);
        }
        return params;
    }
}

