/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.domain.vo;

import cn.foxtech.common.constant.HttpStatus;
import cn.foxtech.device.domain.vo.OperateRespondVO;
import cn.foxtech.device.domain.vo.TaskVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TaskRespondVO
extends TaskVO {
    private List<OperateRespondVO> respondVOS = new ArrayList<OperateRespondVO>();
    private Integer code = HttpStatus.SUCCESS;
    private String msg = "";

    public static TaskRespondVO error(int code, String msg) {
        TaskRespondVO vo = new TaskRespondVO();
        vo.setCode(code);
        vo.setMsg(msg);
        return vo;
    }

    public static TaskRespondVO error(String msg) {
        return TaskRespondVO.error(HttpStatus.ERROR, msg);
    }

    public static TaskRespondVO buildRespondVO(OperateRespondVO operateRespondVO, String clientName) {
        TaskRespondVO taskRespondVO = new TaskRespondVO();
        taskRespondVO.setUuid(operateRespondVO.getUuid());
        taskRespondVO.setClientName(clientName);
        taskRespondVO.setTimeout(operateRespondVO.getTimeout());
        taskRespondVO.getRespondVOS().add(operateRespondVO);
        return taskRespondVO;
    }

    public static TaskRespondVO buildRespondVO(Map<String, Object> operateRespondMap) {
        TaskRespondVO taskRespondVO = new TaskRespondVO();
        taskRespondVO.bindBaseVO(operateRespondMap);
        taskRespondVO.setMsg((String)operateRespondMap.get("msg"));
        taskRespondVO.setCode((Integer)operateRespondMap.get("code"));
        List respondVOS = (List)operateRespondMap.get("respondVOS");
        for (Map respondMap : respondVOS) {
            OperateRespondVO respondVO = OperateRespondVO.buildOperateRespondVO(respondMap);
            taskRespondVO.getRespondVOS().add(respondVO);
        }
        return taskRespondVO;
    }

    public List<OperateRespondVO> getRespondVOS() {
        return this.respondVOS;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setRespondVOS(List<OperateRespondVO> respondVOS) {
        this.respondVOS = respondVOS;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

