/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.controller.common.service;

import cn.foxtech.common.rpc.redis.device.client.RedisListDeviceClient;
import cn.foxtech.core.exception.ServiceException;
import cn.foxtech.device.domain.vo.TaskRequestVO;
import cn.foxtech.device.domain.vo.TaskRespondVO;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeviceOperateService {
    private static final int timeout_device = 2000;
    @Autowired
    private RedisListDeviceClient deviceClient;

    public TaskRespondVO execute(TaskRequestVO requestVO) throws ServiceException {
        Integer timeout = requestVO.getTimeout();
        String key = requestVO.getUuid();
        if (key == null || key.isEmpty()) {
            key = UUID.randomUUID().toString().replace("-", "");
            requestVO.setUuid(key);
        }
        this.deviceClient.pushDeviceRequest(requestVO);
        TaskRespondVO respondVO = this.deviceClient.getDeviceRespond(key, (long)(timeout + 2000));
        if (respondVO == null) {
            return TaskRespondVO.error((String)"Device Service \u54cd\u5e94\u8d85\u65f6\uff01");
        }
        return respondVO;
    }
}

