/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.controller.common.service;

import cn.foxtech.common.utils.syncobject.SyncFlagObjectMap;
import cn.foxtech.controller.common.redistopic.RedisTopicPuberService;
import cn.foxtech.controller.common.service.EntityManageService;
import cn.foxtech.core.exception.ServiceException;
import cn.foxtech.device.domain.vo.TaskRequestVO;
import cn.foxtech.device.domain.vo.TaskRespondVO;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DeviceOperateService {
    private static final int timeout_device = 2000;
    @Autowired
    EntityManageService entityService;
    @Autowired
    private RedisTopicPuberService publisher;
    @Value(value="${spring.redis_topic.controller_model}")
    private String controller_model = "system_controller";

    public Map<String, Object> execute(Map<String, Object> request) throws InterruptedException, ServiceException, TimeoutException {
        if (!request.containsKey("clientName")) {
            request.put("clientName", this.controller_model);
        }
        Integer timeout = (Integer)request.get("timeout");
        String key = (String)request.get("uuid");
        if (key == null || key.isEmpty()) {
            key = UUID.randomUUID().toString().replace("-", "");
            request.put("uuid", key);
        }
        SyncFlagObjectMap.inst().reset(key);
        this.publisher.sendRespondVO(request);
        Map respond = (Map)SyncFlagObjectMap.inst().waitDynamic(key, (long)(timeout + 2000));
        if (respond == null) {
            throw new TimeoutException("Device Service \u54cd\u5e94\u8d85\u65f6\uff01");
        }
        return respond;
    }

    public TaskRespondVO execute(TaskRequestVO requestVO) throws InterruptedException, ServiceException, TimeoutException {
        Integer timeout = requestVO.getTimeout();
        String key = requestVO.getUuid();
        if (key == null || key.isEmpty()) {
            key = UUID.randomUUID().toString().replace("-", "");
            requestVO.setUuid(key);
        }
        SyncFlagObjectMap.inst().reset(key);
        this.publisher.sendRequestVO(requestVO);
        TaskRespondVO respondVO = (TaskRespondVO)SyncFlagObjectMap.inst().waitDynamic(key, (long)(timeout + 2000));
        if (respondVO == null) {
            return TaskRespondVO.error((String)"Device Service \u54cd\u5e94\u8d85\u65f6\uff01");
        }
        return respondVO;
    }
}

