/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.controller.common.redistopic;

import cn.foxtech.common.utils.json.JsonUtils;
import cn.foxtech.common.utils.redis.topic.service.RedisTopicSubscriber;
import cn.foxtech.common.utils.syncobject.SyncFlagObjectMap;
import cn.foxtech.common.utils.syncobject.SyncQueueObjectMap;
import cn.foxtech.device.domain.vo.OperateRespondVO;
import cn.foxtech.device.domain.vo.TaskRespondVO;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RedisTopicSuberService
extends RedisTopicSubscriber {
    private static final Logger logger = Logger.getLogger(RedisTopicSuberService.class);
    @Value(value="${spring.redis_topic.controller_model}")
    private String controller_model = "system_controller";

    public String topic1st() {
        return "topic_device_respond_" + this.controller_model;
    }

    public String topic2nd() {
        return "topic_device_respond_public";
    }

    public void receiveTopic1st(String message) {
        try {
            TaskRespondVO respondVO = (TaskRespondVO)JsonUtils.buildObject((String)message, TaskRespondVO.class);
            String key = respondVO.getUuid();
            if (key == null || key.isEmpty()) {
                logger.info((Object)("\u63a5\u6536\u5230\u7684\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u53ea\u8981\u8981\u5305\u542buuid\uff1a" + message));
                return;
            }
            SyncFlagObjectMap.inst().notifyDynamic(key, (Object)respondVO);
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    public void receiveTopic2nd(String message) {
        try {
            TaskRespondVO respondVO = (TaskRespondVO)JsonUtils.buildObject((String)message, TaskRespondVO.class);
            for (OperateRespondVO operateRespondVO : respondVO.getRespondVOS()) {
                String operateMode = operateRespondVO.getOperateMode();
                if (operateMode == null) {
                    logger.debug((Object)("\u63a5\u6536\u5230\u7684\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + message));
                    continue;
                }
                if ("report".equals(operateMode)) {
                    SyncQueueObjectMap.inst().push("report", (Object)operateRespondVO, 1000);
                    continue;
                }
                if (!"exchange".equals(operateMode)) continue;
                SyncQueueObjectMap.inst().push("exchange", (Object)operateRespondVO, 1000);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }
}

