/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.xml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class XmlReader {
    public static Map<String, Object> parse(String xml) {
        return XmlReader.parse(xml, "xml", "");
    }

    public static Map<String, Object> parse(String xml, String rootName, String defaultNullValue) {
        HashMap<String, AtomicInteger> contextMap = new HashMap<String, AtomicInteger>();
        Map<String, Object> map = null;
        StringReader stringReader = null;
        try {
            stringReader = new StringReader(xml);
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(stringReader);
            map = XmlReader.doParse(reader, contextMap, rootName, defaultNullValue);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            if (null != stringReader) {
                try {
                    stringReader.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return map;
    }

    private static Map<String, Object> doParse(XMLStreamReader reader, Map<String, AtomicInteger> contextMap, String rootName, String defaultNullValue) throws Throwable {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, Object> currentMap = map;
        int event = reader.getEventType();
        ArrayList<String> names = new ArrayList<String>();
        int taglength = 0;
        String tagName = null;
        String tagValue = defaultNullValue;
        while (true) {
            switch (event) {
                case 7: {
                    break;
                }
                case 1: {
                    Object object;
                    int i;
                    tagValue = defaultNullValue;
                    tagName = reader.getLocalName();
                    if (rootName.equals(tagName)) break;
                    names.add(tagName);
                    currentMap = map;
                    if (++taglength > 1) {
                        for (i = 0; i < taglength - 1; ++i) {
                            object = currentMap.get(names.get(i));
                            if (null == object) {
                                object = new HashMap();
                                currentMap.put((String)names.get(i), object);
                                currentMap = (Map)object;
                                continue;
                            }
                            int currentTagNameSize = XmlReader.getSize(contextMap, i + 1 + "" + (String)names.get(i));
                            if (currentTagNameSize > 1) {
                                Map tempMap;
                                List parentList;
                                if (object instanceof Map) {
                                    parentList = new ArrayList();
                                    parentList.add(object);
                                    HashMap tempMap2 = new HashMap();
                                    parentList.add(tempMap2);
                                    currentMap.put((String)names.get(i), parentList);
                                    currentMap = tempMap2;
                                    continue;
                                }
                                if (!(object instanceof List)) continue;
                                parentList = (List)object;
                                int parentListSize = parentList.size();
                                if (parentListSize != currentTagNameSize) {
                                    tempMap = new HashMap();
                                    parentList.add(tempMap);
                                    currentMap = tempMap;
                                    continue;
                                }
                                tempMap = (Map)parentList.get(parentList.size() - 1);
                                currentMap = tempMap;
                                continue;
                            }
                            currentMap = (Map)object;
                        }
                    }
                    XmlReader.add(contextMap, names.size() + tagName);
                    break;
                }
                case 4: {
                    tagValue = reader.getText();
                    break;
                }
                case 2: {
                    Object object;
                    int i;
                    tagName = reader.getLocalName();
                    if (rootName.equals(tagName)) break;
                    currentMap = map;
                    if (taglength > 1) {
                        for (i = 0; i < taglength - 1; ++i) {
                            object = currentMap.get(names.get(i));
                            if (null == object) continue;
                            if (object instanceof List) {
                                List list = (List)object;
                                currentMap = (Map)list.get(list.size() - 1);
                                continue;
                            }
                            if (!(object instanceof Map)) continue;
                            currentMap = (Map)object;
                        }
                    }
                    Object oldValue = currentMap.get(tagName);
                    if (!currentMap.containsKey(tagName)) {
                        currentMap.put(tagName, tagValue);
                        XmlReader.remove(contextMap, names.size() + tagName);
                    } else if (oldValue instanceof List) {
                        Object obj;
                        List list = (List)oldValue;
                        if (list.size() > 0 && (obj = list.get(0)) instanceof String) {
                            ((List)oldValue).add(tagValue);
                            XmlReader.remove(contextMap, names.size() + tagName);
                        }
                    } else if (!(oldValue instanceof Map)) {
                        ArrayList<Object> tmpList = new ArrayList<Object>();
                        currentMap.put(tagName, tmpList);
                        tmpList.add(oldValue);
                        tmpList.add(tagValue);
                        XmlReader.remove(contextMap, names.size() + tagName);
                    }
                    tagValue = defaultNullValue;
                    names.remove(names.size() - 1);
                    --taglength;
                    break;
                }
            }
            if (!reader.hasNext()) break;
            event = reader.next();
        }
        return map;
    }

    private static void add(Map<String, AtomicInteger> contextMap, String nodeName) {
        AtomicInteger integer = contextMap.get(nodeName);
        if (null == integer) {
            integer = new AtomicInteger(0);
            contextMap.put(nodeName, integer);
        }
        integer.incrementAndGet();
    }

    private static void remove(Map<String, AtomicInteger> contextMap, String nodeName) {
        AtomicInteger integer = contextMap.get(nodeName);
        if (null != integer) {
            integer.decrementAndGet();
        }
    }

    private static int getSize(Map<String, AtomicInteger> contextMap, String nodeName) {
        AtomicInteger integer = contextMap.get(nodeName);
        if (null == integer) {
            integer = new AtomicInteger(0);
            contextMap.put(nodeName, integer);
        }
        return integer.intValue();
    }

    public static void main(String[] args) {
        String str = "<xml>\n<auth>\n<randomStr>suiji</randomStr>\n<token>3ed6b709d31e87af73216149dc510c6fc94975af</token>\n</auth>\n<datas>\n<dataStatus>\n<errorCode>0</errorCode>\n<errormsg>\u53d1\u9001\u6210\u529f</errormsg>\n<seqId>1</seqId>\n<lastModifyTime>2018-07-26 11:01:38</lastModifyTime>\n</dataStatus>\n<dataStatus>\n<errorCode>1</errorCode>\n<errormsg>\u53d1\u9001\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e3a\u7a7a</errormsg>\n<seqId>2</seqId>\n<lastModifyTime>2018-07-26 11:02:38</lastModifyTime>\n</dataStatus>\n</datas>\n</xml>";
        Map<String, Object> parse = XmlReader.parse(str);
        System.out.println(parse);
    }
}

