/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.serialport.linux;

import cn.foxtech.common.utils.serialport.ISerialPort;
import cn.foxtech.common.utils.serialport.linux.LinuxAPI;
import cn.foxtech.common.utils.serialport.linux.LinuxMacro;
import cn.foxtech.common.utils.serialport.linux.entity.FD_SET;
import cn.foxtech.common.utils.serialport.linux.entity.TERMIOS;
import cn.foxtech.common.utils.serialport.linux.entity.TIMEVAL;

public class SerialPortLinux
implements ISerialPort {
    private static final LinuxAPI API = LinuxAPI.INSTANCE;
    private final TERMIOS ntm = new TERMIOS();
    private final TERMIOS otm = new TERMIOS();
    private String name = "/dev/ttyS0";
    private int fd = -1;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isOpen() {
        return this.fd > 0;
    }

    @Override
    public boolean open(String name) {
        this.name = "/dev/" + name;
        int oflag = 0;
        int O_RDWR = 2;
        int O_NOCTTY = 256;
        int O_NONBLOCK = 2048;
        oflag |= O_RDWR;
        oflag |= O_NOCTTY;
        this.fd = API.open(this.name, oflag |= O_NONBLOCK);
        if (this.fd < 0) {
            return false;
        }
        int rtn = API.tcgetattr(this.fd, this.otm);
        if (rtn != 0) {
            API.close(this.fd);
            this.fd = -1;
            return false;
        }
        return true;
    }

    @Override
    public boolean setParam(Integer baudRate, String parity, Integer databits, Integer stopbits) {
        if (parity == null) {
            return false;
        }
        parity = parity.toUpperCase();
        API.bzero(this.ntm, this.ntm.size());
        API.cfmakeraw(this.ntm);
        this.ntm.c_cflag |= 0x880;
        this.ntm.c_cflag &= 0xFFFFFFCF;
        switch (databits) {
            case 5: {
                this.ntm.c_cflag |= 0;
                break;
            }
            case 6: {
                this.ntm.c_cflag |= 0x10;
                break;
            }
            case 7: {
                this.ntm.c_cflag |= 0x20;
                break;
            }
            case 8: {
                this.ntm.c_cflag |= 0x30;
                break;
            }
            default: {
                this.ntm.c_cflag |= 0x30;
            }
        }
        if ("N".equals(parity)) {
            this.ntm.c_cflag &= 0xFFFFFEFF;
            this.ntm.c_iflag &= 0xFFFFFFEF;
        } else if ("O".equals(parity)) {
            this.ntm.c_cflag |= 0x300;
            this.ntm.c_iflag |= 0x10;
        } else if ("E".equals(parity)) {
            this.ntm.c_cflag |= 0x100;
            this.ntm.c_cflag &= 0xFFFFFDFF;
            this.ntm.c_iflag |= 0x10;
        } else if ("S".equals(parity)) {
            this.ntm.c_cflag &= 0xFFFFFEFF;
            this.ntm.c_cflag &= 0xFFFFFFBF;
        } else {
            this.ntm.c_cflag &= 0xFFFFFEFF;
            this.ntm.c_iflag &= 0xFFFFFFEF;
        }
        switch (stopbits) {
            case 1: {
                this.ntm.c_cflag &= 0xFFFFFFBF;
                break;
            }
            case 2: {
                this.ntm.c_cflag |= 0x40;
                break;
            }
            default: {
                this.ntm.c_cflag &= 0xFFFFFFBF;
            }
        }
        this.ntm.c_cc[5] = 1;
        this.ntm.c_cc[6] = 1;
        switch (baudRate) {
            case 300: {
                API.cfsetispeed(this.ntm, 7);
                API.cfsetospeed(this.ntm, 7);
                break;
            }
            case 600: {
                API.cfsetispeed(this.ntm, 8);
                API.cfsetospeed(this.ntm, 8);
                break;
            }
            case 1200: {
                API.cfsetispeed(this.ntm, 9);
                API.cfsetospeed(this.ntm, 9);
                break;
            }
            case 1800: {
                API.cfsetispeed(this.ntm, 10);
                API.cfsetospeed(this.ntm, 10);
                break;
            }
            case 2400: {
                API.cfsetispeed(this.ntm, 11);
                API.cfsetospeed(this.ntm, 11);
                break;
            }
            case 4800: {
                API.cfsetispeed(this.ntm, 12);
                API.cfsetospeed(this.ntm, 12);
                break;
            }
            case 9600: {
                API.cfsetispeed(this.ntm, 13);
                API.cfsetospeed(this.ntm, 13);
                break;
            }
            case 19200: {
                API.cfsetispeed(this.ntm, 14);
                API.cfsetospeed(this.ntm, 14);
                break;
            }
            case 38400: {
                API.cfsetispeed(this.ntm, 15);
                API.cfsetospeed(this.ntm, 15);
                break;
            }
            default: {
                API.cfsetispeed(this.ntm, 13);
                API.cfsetospeed(this.ntm, 13);
            }
        }
        int rtn = 0;
        rtn = API.tcflush(this.fd, 0);
        if (rtn != 0) {
            return false;
        }
        rtn = API.tcflush(this.fd, 1);
        if (rtn != 0) {
            return false;
        }
        rtn = API.tcsetattr(this.fd, 0, this.ntm);
        return rtn == 0;
    }

    @Override
    public int sendData(byte[] data) {
        if (this.fd < 0) {
            throw new RuntimeException("\u4e32\u53e3\u5c1a\u672a\u6253\u5f00\uff1a" + this.name);
        }
        int dataLen = data.length;
        byte[] sendData = data;
        int postion = 0;
        while (postion < dataLen) {
            int len = API.write(this.fd, sendData, dataLen - postion);
            if (len > 0) {
                int newLength = dataLen - (postion += len);
                byte[] copy = new byte[newLength];
                System.arraycopy(sendData, postion, copy, 0, Math.min(sendData.length, newLength));
                sendData = copy;
                dataLen = newLength;
                continue;
            }
            if (len > 0) continue;
            break;
        }
        return postion;
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int readData(byte[] readBuffer) {
        if (this.fd < 0) {
            throw new RuntimeException("\u4e32\u53e3\u5c1a\u672a\u6253\u5f00\uff1a" + this.name);
        }
        return API.read(this.fd, readBuffer, readBuffer.length);
    }

    @Override
    public int recvData(byte[] recvBuffer, long minPackInterval, long maxPackInterval) {
        if (this.fd < 0) {
            throw new RuntimeException("\u4e32\u53e3\u5c1a\u672a\u6253\u5f00\uff1a" + this.name);
        }
        TIMEVAL tv = new TIMEVAL();
        tv.tv_sec = maxPackInterval / 1000L;
        tv.tv_usec = maxPackInterval % 1000L;
        FD_SET readset = new FD_SET();
        LinuxMacro.FD_ZERO(readset);
        LinuxMacro.FD_SET(this.fd, readset);
        int maxfd = this.fd + 1;
        if (API.select(maxfd, readset, null, null, tv) < 0) {
            throw new RuntimeException("\u4e32\u53e3select\u5f02\u5e38\uff1a" + this.name);
        }
        int count = 0;
        if (LinuxMacro.FD_ISSET(this.fd, readset)) {
            this.sleep(minPackInterval);
            count = API.read(this.fd, recvBuffer, recvBuffer.length);
        }
        return count;
    }

    @Override
    public int recvData(byte[] data, long mTimeout) {
        return this.recvData(data, 10L, mTimeout);
    }

    @Override
    public boolean clearRecvFlush() {
        if (this.fd < 0) {
            return false;
        }
        int rtn = API.tcflush(this.fd, 0);
        return rtn == 0;
    }

    @Override
    public boolean clearSendFlush() {
        if (this.fd < 0) {
            return false;
        }
        int rtn = API.tcflush(this.fd, 1);
        return rtn == 0;
    }

    @Override
    public boolean close() {
        if (this.fd <= 0) {
            return false;
        }
        API.tcsetattr(this.fd, 1, this.otm);
        API.close(this.fd);
        this.fd = -1;
        return true;
    }
}

