/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.serialport.win32;

import cn.foxtech.common.utils.serialport.ISerialPort;
import cn.foxtech.common.utils.serialport.win32.Win32API;
import cn.foxtech.common.utils.serialport.win32.Win32Macro;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;

public class SerialPortWin32
implements ISerialPort {
    private static final Kernel32 KERNEL = Kernel32.INSTANCE;
    private static final Win32API KERNELPLUS = Win32API.INSTANCE;
    private static final Pointer INVALID_HANDLE_VALUE = Pointer.createConstant((long)0xFFFFFFFFL);
    private WinNT.HANDLE handle = null;
    private String name = "COM1";

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isOpen() {
        if (this.handle == null) {
            return false;
        }
        return !this.handle.getPointer().equals((Object)INVALID_HANDLE_VALUE);
    }

    private void closeHandle() {
        if (this.handle == null) {
            return;
        }
        if (this.handle.getPointer().equals((Object)INVALID_HANDLE_VALUE)) {
            return;
        }
        KERNEL.CloseHandle(this.handle);
        this.handle = null;
    }

    @Override
    public boolean setParam(Integer baudRate, String parity, Integer databits, Integer stopbits) {
        if (!this.isOpen()) {
            return false;
        }
        WinBase.DCB dcb = new WinBase.DCB();
        if (!KERNEL.GetCommState(this.handle, dcb)) {
            this.closeHandle();
            return false;
        }
        String formatBcd = this.name + ":" + baudRate + "," + parity.toLowerCase() + "," + databits.toString() + "," + stopbits.toString();
        if (!KERNELPLUS.BuildCommDCB(formatBcd, dcb)) {
            return false;
        }
        WinBase.COMMTIMEOUTS CommTimeOuts = new WinBase.COMMTIMEOUTS();
        CommTimeOuts.ReadIntervalTimeout = new WinDef.DWORD(-1L);
        CommTimeOuts.ReadTotalTimeoutMultiplier = new WinDef.DWORD(0L);
        CommTimeOuts.ReadTotalTimeoutConstant = new WinDef.DWORD(0L);
        CommTimeOuts.WriteTotalTimeoutMultiplier = new WinDef.DWORD(0L);
        CommTimeOuts.WriteTotalTimeoutConstant = new WinDef.DWORD(2500L);
        if (!KERNEL.SetCommTimeouts(this.handle, CommTimeOuts)) {
            return false;
        }
        if (!KERNEL.SetCommState(this.handle, dcb)) {
            return false;
        }
        return KERNELPLUS.SetupComm(this.handle, new WinDef.DWORD(4096L), new WinDef.DWORD(4096L));
    }

    @Override
    public boolean open(String szPort) {
        if (!szPort.startsWith("COM")) {
            return false;
        }
        String no = szPort.substring("COM".length());
        if (Integer.parseInt(no) >= 10) {
            szPort = "\\\\.\\COM" + szPort.substring("COM".length());
        }
        this.handle = KERNEL.CreateFile(szPort, -1073741824, 0, null, 3, 128, null);
        if (this.handle.getPointer().equals((Object)INVALID_HANDLE_VALUE)) {
            return false;
        }
        this.name = szPort;
        WinBase.COMMTIMEOUTS CommTimeOuts = new WinBase.COMMTIMEOUTS();
        CommTimeOuts.ReadIntervalTimeout = new WinDef.DWORD(-1L);
        CommTimeOuts.ReadTotalTimeoutMultiplier = new WinDef.DWORD(0L);
        CommTimeOuts.ReadTotalTimeoutConstant = new WinDef.DWORD(0L);
        CommTimeOuts.WriteTotalTimeoutMultiplier = new WinDef.DWORD(0L);
        CommTimeOuts.WriteTotalTimeoutConstant = new WinDef.DWORD(2500L);
        if (!KERNEL.SetCommTimeouts(this.handle, CommTimeOuts)) {
            this.closeHandle();
            return false;
        }
        return true;
    }

    @Override
    public boolean close() {
        if (!this.isOpen()) {
            return false;
        }
        if (!KERNELPLUS.SetCommMask(this.handle, null)) {
            return false;
        }
        this.closeHandle();
        return true;
    }

    @Override
    public int sendData(byte[] data) {
        if (!this.isOpen()) {
            throw new RuntimeException("\u4e32\u53e3\u5c1a\u672a\u6253\u5f00\uff1a" + this.name);
        }
        IntByReference dwBytesWritten = new IntByReference();
        boolean bWriteStat = KERNEL.WriteFile(this.handle, data, data.length, dwBytesWritten, null);
        return dwBytesWritten.getValue();
    }

    public void ClearCommError() {
        if (!this.isOpen()) {
            throw new RuntimeException("\u4e32\u53e3\u5c1a\u672a\u6253\u5f00\uff1a" + this.name);
        }
        WinDef.DWORDByReference dwErrorFlags = new WinDef.DWORDByReference();
        Win32Macro.COMSTAT ComStat = new Win32Macro.COMSTAT();
        if (!KERNELPLUS.ClearCommError(this.handle, dwErrorFlags, ComStat)) {
            throw new RuntimeException("ClearCommError\u5f02\u5e38\uff1a" + this.name);
        }
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(5L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int readData(byte[] readBuffer) {
        if (!this.isOpen()) {
            throw new RuntimeException("\u4e32\u53e3\u5c1a\u672a\u6253\u5f00\uff1a" + this.name);
        }
        IntByReference lngBytesRead = new IntByReference();
        KERNEL.ReadFile(this.handle, readBuffer, readBuffer.length, lngBytesRead, null);
        return lngBytesRead.getValue();
    }

    @Override
    public int recvData(byte[] recvBuffer, long minPackInterval, long maxPackInterval) {
        if (!this.isOpen()) {
            throw new RuntimeException("\u4e32\u53e3\u5c1a\u672a\u6253\u5f00\uff1a" + this.name);
        }
        if (minPackInterval < 10L) {
            minPackInterval = 10L;
        }
        if (minPackInterval > 1000L) {
            minPackInterval = 1000L;
        }
        long start = System.currentTimeMillis();
        int recvCount = 0;
        boolean hasRead = false;
        byte[] tempBuff = new byte[256];
        while (true) {
            IntByReference lngBytesRead = new IntByReference();
            KERNEL.ReadFile(this.handle, tempBuff, tempBuff.length, lngBytesRead, null);
            if (lngBytesRead.getValue() > 0) {
                if (lngBytesRead.getValue() + recvCount > recvBuffer.length) {
                    return recvCount;
                }
                System.arraycopy(tempBuff, 0, recvBuffer, recvCount, Math.min(recvBuffer.length - recvCount, lngBytesRead.getValue()));
                recvCount += lngBytesRead.getValue();
                hasRead = true;
            }
            if (hasRead) {
                if (lngBytesRead.getValue() <= 0) break;
                this.sleep(minPackInterval);
                continue;
            }
            long spand = System.currentTimeMillis() - start;
            if (spand > maxPackInterval) break;
            this.sleep(minPackInterval);
        }
        return recvCount;
    }

    @Override
    public int recvData(byte[] recvBuffer, long uTimeout) {
        return this.recvData(recvBuffer, 10L, uTimeout);
    }

    @Override
    public boolean clearRecvFlush() {
        if (!this.isOpen()) {
            return false;
        }
        return KERNELPLUS.PurgeComm(this.handle, new WinDef.DWORD(10L));
    }

    @Override
    public boolean clearSendFlush() {
        if (!this.isOpen()) {
            return false;
        }
        return KERNELPLUS.PurgeComm(this.handle, new WinDef.DWORD(5L));
    }
}

