/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.serialport.linux;

import cn.foxtech.common.utils.serialport.ISerialPort;
import cn.foxtech.common.utils.serialport.linux.LinuxAPI;
import cn.foxtech.common.utils.serialport.linux.LinuxMacro;
import cn.foxtech.common.utils.serialport.linux.entity.FD_SET;
import cn.foxtech.common.utils.serialport.linux.entity.OutValue;
import cn.foxtech.common.utils.serialport.linux.entity.TERMIOS;
import cn.foxtech.common.utils.serialport.linux.entity.TIMEVAL;

public class SerialPortLinux
implements ISerialPort {
    private static final LinuxAPI API = LinuxAPI.INSTANCE;
    private String name = "/dev/ttyS0";
    private int fd = -1;
    private TERMIOS ntm = new TERMIOS();
    private TERMIOS otm = new TERMIOS();
    private byte[] data = new byte[1024];
    private long uTimeOut = 100000L;

    @Override
    public boolean isOpen() {
        return this.fd > 0;
    }

    @Override
    public boolean open(String name) {
        this.name = "/dev/" + name;
        int oflag = 0;
        int O_RDWR = 2;
        int O_NOCTTY = 256;
        int O_NONBLOCK = 2048;
        oflag |= O_RDWR;
        oflag |= O_NOCTTY;
        this.fd = API.open(this.name, oflag |= O_NONBLOCK);
        if (this.fd < 0) {
            return false;
        }
        int rtn = API.tcgetattr(this.fd, this.otm);
        if (rtn != 0) {
            API.close(this.fd);
            this.fd = -1;
            return false;
        }
        return true;
    }

    @Override
    public boolean setParam(Integer baudRate, String parity, Integer databits, Integer stopbits) {
        if (parity == null) {
            return false;
        }
        parity = parity.toUpperCase();
        API.bzero(this.ntm, this.ntm.size());
        API.cfmakeraw(this.ntm);
        switch (baudRate) {
            case 300: {
                this.ntm.c_cflag |= 7;
                break;
            }
            case 600: {
                this.ntm.c_cflag |= 8;
                break;
            }
            case 1200: {
                this.ntm.c_cflag |= 9;
                break;
            }
            case 1800: {
                this.ntm.c_cflag |= 0xA;
                break;
            }
            case 2400: {
                this.ntm.c_cflag |= 0xB;
                break;
            }
            case 4800: {
                this.ntm.c_cflag |= 0xC;
                break;
            }
            case 9600: {
                this.ntm.c_cflag |= 0xD;
                break;
            }
            case 19200: {
                this.ntm.c_cflag |= 0xE;
                break;
            }
            case 38400: {
                this.ntm.c_cflag |= 0xF;
                break;
            }
            default: {
                this.ntm.c_cflag |= 0xD;
            }
        }
        this.ntm.c_cflag = baudRate;
        this.ntm.c_cflag |= 0x880;
        this.ntm.c_cflag &= 0xFFFFFFCF;
        switch (databits) {
            case 5: {
                this.ntm.c_cflag |= 0;
                break;
            }
            case 6: {
                this.ntm.c_cflag |= 0x10;
                break;
            }
            case 7: {
                this.ntm.c_cflag |= 0x20;
                break;
            }
            case 8: {
                this.ntm.c_cflag |= 0x30;
                break;
            }
            default: {
                this.ntm.c_cflag |= 0x30;
            }
        }
        if ("N".equals(parity)) {
            this.ntm.c_cflag &= 0xFFFFFEFF;
            this.ntm.c_iflag &= 0xFFFFFFEF;
        } else if ("O".equals(parity)) {
            this.ntm.c_cflag |= 0x300;
            this.ntm.c_iflag |= 0x10;
        } else if ("E".equals(parity)) {
            this.ntm.c_cflag |= 0x100;
            this.ntm.c_cflag &= 0xFFFFFDFF;
            this.ntm.c_iflag |= 0x10;
        } else if ("S".equals(parity)) {
            this.ntm.c_cflag &= 0xFFFFFEFF;
            this.ntm.c_cflag &= 0xFFFFFFBF;
        } else {
            this.ntm.c_cflag &= 0xFFFFFEFF;
            this.ntm.c_iflag &= 0xFFFFFFEF;
        }
        switch (stopbits) {
            case 1: {
                this.ntm.c_cflag &= 0xFFFFFFBF;
                break;
            }
            case 2: {
                this.ntm.c_cflag |= 0x40;
                break;
            }
            default: {
                this.ntm.c_cflag &= 0xFFFFFFBF;
            }
        }
        this.ntm.c_cc[5] = 1;
        this.ntm.c_cc[6] = 1;
        int rtn = 0;
        rtn = API.tcflush(this.fd, 0);
        if (rtn != 0) {
            return false;
        }
        rtn = API.tcflush(this.fd, 1);
        if (rtn != 0) {
            return false;
        }
        rtn = API.tcsetattr(this.fd, 0, this.ntm);
        return rtn == 0;
    }

    @Override
    public boolean sendData(byte[] data, OutValue sendLen) {
        if (this.fd < 0) {
            return false;
        }
        int dataLen = data.length;
        byte[] sendData = data;
        int postion = 0;
        while (postion < dataLen) {
            int len = API.write(this.fd, sendData, dataLen - postion);
            if (len > 0) {
                int newLength = dataLen - (postion += len);
                byte[] copy = new byte[newLength];
                System.arraycopy(sendData, postion, copy, 0, Math.min(sendData.length, newLength));
                sendData = copy;
                dataLen = newLength;
                continue;
            }
            if (len > 0) continue;
            break;
        }
        sendLen.setObject(postion);
        return true;
    }

    @Override
    public boolean recvData(byte[] data, long mTimeout, OutValue recvLen) {
        recvLen.setObject(0);
        if (this.fd < 0) {
            return false;
        }
        FD_SET readset = new FD_SET();
        LinuxMacro.FD_ZERO(readset);
        LinuxMacro.FD_SET(this.fd, readset);
        TIMEVAL tv = new TIMEVAL();
        tv.tv_sec = mTimeout / 1000L;
        tv.tv_usec = mTimeout % 1000L;
        int maxfd = this.fd + 1;
        if (API.select(maxfd, readset, null, null, tv) < 0) {
            return false;
        }
        if (LinuxMacro.FD_ISSET(this.fd, readset)) {
            int recv = API.read(this.fd, data, data.length);
            recvLen.setObject(recv);
        }
        return true;
    }

    @Override
    public boolean clearRecvFlush() {
        if (this.fd < 0) {
            return false;
        }
        int rtn = API.tcflush(this.fd, 0);
        return rtn == 0;
    }

    @Override
    public boolean clearSendFlush() {
        if (this.fd < 0) {
            return false;
        }
        int rtn = API.tcflush(this.fd, 1);
        return rtn == 0;
    }

    @Override
    public boolean close() {
        if (this.fd <= 0) {
            return false;
        }
        API.tcsetattr(this.fd, 1, this.otm);
        API.close(this.fd);
        this.fd = -1;
        return true;
    }
}

