/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.scheduler.multitask;

import cn.foxtech.common.utils.scheduler.multitask.PeriodTask;
import cn.foxtech.common.utils.scheduler.multitask.PeriodTaskManager;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodTaskScheduler.class);
    private final PeriodTaskManager taskManager = new PeriodTaskManager();

    public void schedule() {
        this.newShareSchedule();
        this.newAloneSchedule();
    }

    private void newShareSchedule() {
        PeriodTaskManager taskManager = this.taskManager;
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(1000L);
                            PeriodTaskScheduler.this.executeOnceTask();
                            PeriodTaskScheduler.this.executeShareTask();
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.error("\u8c03\u5ea6\u4efb\u52a1\uff1a", e);
                        continue;
                    }
                    break;
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
        scheduledExecutorService.shutdown();
    }

    private void executeShareTask() {
        List<PeriodTask> periodTaskList = this.taskManager.queryShareTask(System.currentTimeMillis());
        for (PeriodTask periodTask : periodTaskList) {
            try {
                periodTask.execute();
            }
            catch (Throwable e) {
                LOGGER.error(periodTask.getClass().getSimpleName(), e);
            }
            this.taskManager.updateShareTask(periodTask, System.currentTimeMillis());
        }
    }

    private void executeOnceTask() {
        List<PeriodTask> tempTaskList = this.taskManager.queryOnceTask();
        for (PeriodTask periodTask : tempTaskList) {
            try {
                periodTask.execute();
            }
            catch (Throwable e) {
                LOGGER.error(periodTask.getClass().getSimpleName(), e);
            }
        }
        tempTaskList.clear();
    }

    private void newAloneSchedule() {
        PeriodTaskManager taskManager = this.taskManager;
        List<PeriodTask> aloneTaskList = taskManager.queryAloneTask();
        for (final PeriodTask task : aloneTaskList) {
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
            scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        task.execute();
                    }
                    catch (Throwable e) {
                        LOGGER.error("\u8c03\u5ea6\u4efb\u52a1\uff1a", e);
                    }
                }
            }, 0L, task.getSchedulePeriod(), TimeUnit.SECONDS);
        }
    }

    public void insertPeriodTask(PeriodTask periodTask) {
        this.taskManager.insertTask(periodTask);
    }
}

