/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.reflect;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.function.Function;

public class ReflectionUtils {
    public static <E, R> String getMethodName(SerializableFunction<E, R> function) {
        try {
            Method method = function.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(function, new Object[0]);
            String implMethodName = serializedLambda.getImplMethodName();
            return implMethodName;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static <E, R, T> Method getMethod(Class<T> clazz, SerializableFunction<E, R> function) {
        try {
            String methodName = ReflectionUtils.getMethodName(function);
            return clazz.getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @FunctionalInterface
    public static interface SerializableFunction<E, R>
    extends Function<E, R>,
    Serializable {
    }
}

