/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.reflect;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class JarLoaderUtils {
    private static final Logger logger = Logger.getLogger(JarLoaderUtils.class);

    public static Set<Class<?>> getClasses(String pack) {
        LinkedHashSet classes = new LinkedHashSet();
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        Enumeration<URL> dirs = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            dirs = classLoader.getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    JarLoaderUtils.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(classLoader.loadClass(packageName + '.' + className));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        });
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (File file : dirfiles) {
            if (file.isDirectory()) {
                JarLoaderUtils.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(classLoader.loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadJar(String jarFilePathName) {
        File jarFile = new File(jarFilePathName);
        JarLoaderUtils.loadJar(jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJar(File jarFile) {
        AccessibleObject method = null;
        try {
            method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        }
        catch (NoSuchMethodException | SecurityException e1) {
            logger.error((Object)e1.getMessage());
        }
        boolean accessible = method.isAccessible();
        try {
            ((Method)method).setAccessible(true);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL url = jarFile.toURI().toURL();
            ((Method)method).invoke(classLoader, url);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            ((Method)method).setAccessible(accessible);
        }
    }
}

