/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.utils.common.utils.redis.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisService {
    @Autowired
    private RedisTemplate redisTemplate;

    public <T> void setCacheObject(String key, T value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public <T> void setCacheObject(String key, T value, Long timeout, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)key, value, timeout.longValue(), timeUnit);
    }

    public Set<String> rangeCacheZSet(String key) {
        return this.redisTemplate.opsForZSet().range((Object)key, 0L, -1L);
    }

    public Map<String, Double> rangeWithScoresCacheZSet(String key, long start, long end) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        Set rang = this.redisTemplate.opsForZSet().rangeWithScores((Object)key, start, end);
        for (ZSetOperations.TypedTuple typedTuple : rang) {
            map.put((String)typedTuple.getValue(), typedTuple.getScore());
        }
        return map;
    }

    public Long removeRangeCacheZSet(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().removeRange((Object)key, start, end);
    }

    public Long addIfAbsentCacheZSet(String key, Map<String, Double> map) {
        HashSet<DefaultTypedTuple> typles = new HashSet<DefaultTypedTuple>();
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            DefaultTypedTuple objectTypedTuple = new DefaultTypedTuple((Object)entry.getKey(), entry.getValue());
            typles.add(objectTypedTuple);
        }
        return this.redisTemplate.opsForZSet().addIfAbsent((Object)key, typles);
    }

    public Long addIfAbsentCacheZSet(String key, Set<String> hkeys) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (String hkey : hkeys) {
            map.put(hkey, 0.0);
        }
        return this.addIfAbsentCacheZSet(key, map);
    }

    public Double incrementScoreCacheZSet(String key, String vkey, double delta) {
        return this.redisTemplate.opsForZSet().incrementScore((Object)key, (Object)vkey, delta);
    }

    public Set<String> rangeByScoreScoreCacheZSet(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().rangeByScore((Object)key, min, max);
    }

    public boolean expire(String key, long timeout) {
        return this.expire(key, timeout, TimeUnit.MILLISECONDS);
    }

    public boolean expire(String key, long timeout, TimeUnit unit) {
        return this.redisTemplate.expire((Object)key, timeout, unit);
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public <T> T getCacheObject(String key) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        return (T)operation.get((Object)key);
    }

    public boolean deleteObject(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public long deleteObject(Collection collection) {
        return this.redisTemplate.delete(collection);
    }

    public <T> long setCacheList(String key, List<T> dataList) {
        Long count = this.redisTemplate.opsForList().rightPushAll((Object)key, dataList);
        return count == null ? 0L : count;
    }

    public <T> List<T> getCacheList(String key) {
        return this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
    }

    public <T> BoundSetOperations<String, T> setCacheSet(String key, Set<T> dataSet) {
        BoundSetOperations setOperation = this.redisTemplate.boundSetOps((Object)key);
        Iterator<T> it = dataSet.iterator();
        while (it.hasNext()) {
            setOperation.add(new Object[]{it.next()});
        }
        return setOperation;
    }

    public <T> Set<T> getCacheSet(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public <T> void setCacheMap(String key, Map<String, T> dataMap) {
        if (dataMap != null) {
            this.redisTemplate.opsForHash().putAll((Object)key, dataMap);
        }
    }

    public <T> Map<String, T> getCacheMap(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public <T> List<T> getCacheMap(String key, Collection<String> hashKeys) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, hashKeys);
    }

    public <T> Long deleteCacheMap(String key, String hashKey) {
        return this.redisTemplate.opsForHash().delete((Object)key, new Object[]{hashKey});
    }

    public <T> void setCacheMapValue(String key, String hKey, T value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hKey, value);
    }

    public <T> T getCacheMapValue(String key, String hKey) {
        HashOperations opsForHash = this.redisTemplate.opsForHash();
        return (T)opsForHash.get((Object)key, (Object)hKey);
    }

    public <T> List<T> readEntityMap(String key, Collection hKeys) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, hKeys);
    }

    public Collection<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }
}

