/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.redis.value;

import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class RedisValueService {
    @Autowired
    private RedisTemplate redisTemplate;
    private long timeout = 60L;

    public abstract String getKey();

    protected void set(String hashKey, Object value) {
        if (hashKey == null || hashKey.isEmpty() || value == null) {
            return;
        }
        String mainKey = this.getKey() + ":" + hashKey;
        this.redisTemplate.opsForValue().set((Object)mainKey, value);
        this.expire(mainKey, this.timeout);
    }

    protected Object get(String hashKey, long timeout) {
        String mainKey = this.getKey() + ":" + hashKey;
        return this.getValue(mainKey, timeout);
    }

    protected Object get(String prefixKey, String hashKey, long timeout) {
        String mainKey = prefixKey + ":" + hashKey;
        return this.getValue(mainKey, timeout);
    }

    protected Object getValue(String mainKey, long timeout) {
        try {
            long start = System.currentTimeMillis();
            while (true) {
                Object data;
                if ((data = this.redisTemplate.opsForValue().get((Object)mainKey)) != null) {
                    this.expire(mainKey, 0L);
                    return data;
                }
                if (System.currentTimeMillis() - start > timeout) {
                    return null;
                }
                Thread.sleep(5L);
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void expire(String mainKey, long timeout) {
        if (this.timeout == -1L) {
            return;
        }
        this.redisTemplate.expire((Object)mainKey, timeout, TimeUnit.SECONDS);
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

