/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.redis.topic.config;

import cn.foxtech.common.utils.redis.topic.service.RedisTopicSubscriber;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class RedisTopicListenerConfig {
    @Autowired
    private RedisTopicSubscriber redisTopicSubscriber;

    @Bean
    public ThreadPoolTaskExecutor springSessionRedisTaskExecutor() {
        ThreadPoolTaskExecutor springSessionRedisTaskExecutor = new ThreadPoolTaskExecutor();
        springSessionRedisTaskExecutor.setCorePoolSize(4);
        springSessionRedisTaskExecutor.setMaxPoolSize(8);
        springSessionRedisTaskExecutor.setKeepAliveSeconds(10);
        springSessionRedisTaskExecutor.setQueueCapacity(1000);
        springSessionRedisTaskExecutor.setThreadNamePrefix("Spring session redis executor thread: ");
        return springSessionRedisTaskExecutor;
    }

    @Bean
    RedisMessageListenerContainer containerV2(RedisConnectionFactory connectionFactory, ThreadPoolTaskExecutor redisTaskExecutor, MessageListenerAdapter listenerAdapter1st, MessageListenerAdapter listenerAdapter2nd, MessageListenerAdapter listenerAdapter3rd, MessageListenerAdapter listenerAdapter4th, MessageListenerAdapter listenerAdapter5th) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.setTaskExecutor((Executor)redisTaskExecutor);
        if (!this.redisTopicSubscriber.topic1st().isEmpty()) {
            container.addMessageListener((MessageListener)listenerAdapter1st, (Topic)new PatternTopic(this.redisTopicSubscriber.topic1st()));
        }
        if (!this.redisTopicSubscriber.topic2nd().isEmpty()) {
            container.addMessageListener((MessageListener)listenerAdapter2nd, (Topic)new PatternTopic(this.redisTopicSubscriber.topic2nd()));
        }
        if (!this.redisTopicSubscriber.topic3rd().isEmpty()) {
            container.addMessageListener((MessageListener)listenerAdapter3rd, (Topic)new PatternTopic(this.redisTopicSubscriber.topic3rd()));
        }
        if (!this.redisTopicSubscriber.topic4th().isEmpty()) {
            container.addMessageListener((MessageListener)listenerAdapter4th, (Topic)new PatternTopic(this.redisTopicSubscriber.topic4th()));
        }
        if (!this.redisTopicSubscriber.topic5th().isEmpty()) {
            container.addMessageListener((MessageListener)listenerAdapter5th, (Topic)new PatternTopic(this.redisTopicSubscriber.topic5th()));
        }
        return container;
    }

    @Bean
    MessageListenerAdapter listenerAdapter1st() {
        return new MessageListenerAdapter((Object)this.redisTopicSubscriber, "receiveTopic1st");
    }

    @Bean
    MessageListenerAdapter listenerAdapter2nd() {
        return new MessageListenerAdapter((Object)this.redisTopicSubscriber, "receiveTopic2nd");
    }

    @Bean
    MessageListenerAdapter listenerAdapter3rd() {
        return new MessageListenerAdapter((Object)this.redisTopicSubscriber, "receiveTopic3rd");
    }

    @Bean
    MessageListenerAdapter listenerAdapter4th() {
        return new MessageListenerAdapter((Object)this.redisTopicSubscriber, "receiveTopic4th");
    }

    @Bean
    MessageListenerAdapter listenerAdapter5th() {
        return new MessageListenerAdapter((Object)this.redisTopicSubscriber, "receiveTopic5th");
    }
}

