/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.redis.status;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class RedisStatusProducerService {
    @Autowired
    private RedisTemplate redisTemplate;
    @Value(value="${spring.application.name}")
    private String applicationName = "null";
    private long lastTime = 0L;
    private Object data;

    public abstract String getKeySync();

    public abstract String getKeyData();

    public synchronized void save(String serviceKey) {
        this.lastTime = System.currentTimeMillis();
        this.redisTemplate.opsForHash().put((Object)this.getKeySync(), (Object)serviceKey, (Object)this.lastTime);
        this.redisTemplate.opsForHash().put((Object)this.getKeyData(), (Object)serviceKey, this.data);
    }

    public synchronized void load(String serviceKey) {
        Long time = (Long)this.redisTemplate.opsForHash().get((Object)this.getKeySync(), (Object)serviceKey);
        if (time == null) {
            this.lastTime = 0L;
        }
        if (time.equals(this.lastTime)) {
            return;
        }
        this.data = this.redisTemplate.opsForHash().get((Object)this.getKeyData(), (Object)serviceKey);
        this.lastTime = time;
    }

    public synchronized Object getData() {
        return this.data;
    }

    public synchronized void setData(Object value) {
        this.data = value;
    }

    public String getApplicationName() {
        return this.applicationName;
    }
}

