/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.redis.status;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class RedisStatusConsumerService {
    private final Map<String, Status> localMap = new ConcurrentHashMap<String, Status>();
    @Autowired
    private RedisTemplate redisTemplate;
    private boolean inited = false;

    public abstract String getKeySync();

    public abstract String getKeyData();

    public boolean isInited() {
        return this.inited;
    }

    public synchronized boolean load() {
        Map redisSync = this.redisTemplate.opsForHash().entries((Object)this.getKeySync());
        for (String key : redisSync.keySet()) {
            Long updateTime = (Long)redisSync.get(key);
            Status localStatus = this.localMap.get(key);
            if (localStatus == null) {
                localStatus = new Status();
                this.localMap.put(key, localStatus);
            }
            if (localStatus.lastTime == updateTime) continue;
            localStatus.data = this.redisTemplate.opsForHash().get((Object)this.getKeyData(), (Object)key);
            localStatus.lastTime = updateTime;
        }
        this.inited = true;
        return true;
    }

    public synchronized Map<String, Status> getStatus() {
        return this.localMap;
    }

    public static class Status
    implements Serializable {
        private long lastTime = 0L;
        private Object data = "";

        public long getLastTime() {
            return this.lastTime;
        }

        public Object getData() {
            return this.data;
        }

        public void setLastTime(long lastTime) {
            this.lastTime = lastTime;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }
}

