/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.redis.logger;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class RedisLoggerService {
    @Autowired
    private RedisTemplate redisTemplate;
    private long maxSize = 1000L;

    protected abstract String getKey();

    protected void pushAll(List list) {
        this.redisTemplate.opsForList().rightPushAll((Object)this.getKey(), (Collection)list);
        this.removeOverflow(this.getKey());
    }

    protected void push(Object value) {
        this.redisTemplate.opsForList().rightPush((Object)this.getKey(), value);
        this.removeOverflow(this.getKey());
    }

    protected void push(String key, Object value) {
        this.redisTemplate.opsForList().rightPush((Object)key, value);
        this.removeOverflow(key);
    }

    private void removeOverflow(String key) {
        while (this.redisTemplate.opsForList().size((Object)key) > this.maxSize) {
            this.redisTemplate.opsForList().leftPop((Object)key);
        }
    }

    public Long size() {
        return this.redisTemplate.opsForList().size((Object)this.getKey());
    }

    public boolean isBlock() {
        return this.redisTemplate.opsForList().size((Object)this.getKey()) > this.maxSize;
    }

    public boolean isBusy(int percentage) {
        percentage = percentage > 100 ? 100 : percentage;
        percentage = percentage < 10 ? 10 : percentage;
        return this.redisTemplate.opsForList().size((Object)this.getKey()) > this.maxSize * (long)percentage / 100L;
    }

    public Object pop() {
        return this.redisTemplate.opsForList().leftPop((Object)this.getKey());
    }

    public Object pop(long timeout, TimeUnit unit) {
        return this.redisTemplate.opsForList().leftPop((Object)this.getKey(), timeout, unit);
    }

    public Object rangeOne() {
        List list = this.redisTemplate.opsForList().range((Object)this.getKey(), 0L, 1L);
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public <V> List<V> range() {
        return this.redisTemplate.opsForList().range((Object)this.getKey(), 0L, this.maxSize);
    }

    public <V> List<V> range(Long start, Long end) {
        return this.redisTemplate.opsForList().range((Object)this.getKey(), start.longValue(), end.longValue());
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }
}

