/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.redis.logger;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisLoggerService {
    @Autowired
    private RedisTemplate redisTemplate;
    private String key;
    private Long maxSize = 1000L;

    protected void pushAll(List list) {
        this.redisTemplate.opsForList().rightPushAll((Object)this.key, (Collection)list);
        this.removeOverflow();
    }

    protected void push(Object value) {
        this.redisTemplate.opsForList().rightPush((Object)this.key, value);
        this.removeOverflow();
    }

    private void removeOverflow() {
        while (this.redisTemplate.opsForList().size((Object)this.key) > this.maxSize) {
            this.redisTemplate.opsForList().leftPop((Object)this.key);
        }
    }

    public Long size() {
        return this.redisTemplate.opsForList().size((Object)this.key);
    }

    public Object pop() {
        return this.redisTemplate.opsForList().leftPop((Object)this.key);
    }

    public Object rangeOne() {
        List list = this.redisTemplate.opsForList().range((Object)this.key, 0L, 1L);
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public <V> List<V> range() {
        return this.redisTemplate.opsForList().range((Object)this.key, 0L, this.maxSize.longValue());
    }

    public <V> List<V> range(Long start, Long end) {
        return this.redisTemplate.opsForList().range((Object)this.key, start.longValue(), end.longValue());
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public String getKey() {
        return this.key;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }
}

