/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.netty.server.udp;

import cn.foxtech.common.utils.netty.handler.SocketChannelHandler;
import cn.foxtech.common.utils.netty.server.udp.NettyUdpServerHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class NettyUdpServer {
    private final NettyUdpServerHandler serverHandler = new NettyUdpServerHandler();

    public static void createServer(final int port, final SocketChannelHandler channelHandler) {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    NettyUdpServer server = new NettyUdpServer();
                    server.serverHandler.setChannelHandler(channelHandler);
                    server.bind(port);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
        scheduledExecutorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(int port) throws InterruptedException {
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(65535))).handler((ChannelHandler)this.serverHandler);
            bootstrap.bind(port).sync().channel().closeFuture().sync();
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

