/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.netty.client.tcp;

import cn.foxtech.common.utils.netty.handler.BeforeBytesDecoder;
import cn.foxtech.common.utils.netty.handler.BytesToByteDecoder;
import cn.foxtech.common.utils.netty.handler.BytesToByteEncoder;
import cn.foxtech.common.utils.netty.handler.ChannelInboundHandler;
import cn.foxtech.common.utils.netty.handler.SocketChannelHandler;
import cn.foxtech.device.protocol.v1.utils.netty.SplitMessageHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioSocketChannel;

public class NettyTcpClientInitializer
extends ChannelInitializer<NioSocketChannel> {
    private SplitMessageHandler splitMessageHandler;
    private SocketChannelHandler channelHandler = new SocketChannelHandler();

    protected void initChannel(NioSocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new BytesToByteEncoder()});
        if (this.splitMessageHandler != null) {
            BeforeBytesDecoder beforeMessageDecoder = new BeforeBytesDecoder();
            beforeMessageDecoder.setHandler(this.splitMessageHandler);
            pipeline.addLast(new ChannelHandler[]{beforeMessageDecoder});
        }
        pipeline.addLast(new ChannelHandler[]{new BytesToByteDecoder()});
        ChannelInboundHandler channelInboundHandler = new ChannelInboundHandler();
        channelInboundHandler.setChannelHandler(this.channelHandler);
        pipeline.addLast(new ChannelHandler[]{channelInboundHandler});
    }

    public void setSplitMessageHandler(SplitMessageHandler splitMessageHandler) {
        this.splitMessageHandler = splitMessageHandler;
    }

    public void setChannelHandler(SocketChannelHandler channelHandler) {
        this.channelHandler = channelHandler;
    }
}

