/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.netty.server.tcp;

import cn.foxtech.common.utils.netty.handler.BeforeBytesDecoder;
import cn.foxtech.common.utils.netty.handler.BytesToByteDecoder;
import cn.foxtech.common.utils.netty.handler.BytesToByteEncoder;
import cn.foxtech.common.utils.netty.handler.ChannelInboundHandler;
import cn.foxtech.common.utils.netty.handler.SocketChannelHandler;
import cn.foxtech.device.protocol.v1.utils.netty.SplitMessageHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;

public class NettyTcpChannelInitializer<SocketChannel>
extends ChannelInitializer<Channel> {
    private SplitMessageHandler splitMessageHandler = new SplitMessageHandler();
    private SocketChannelHandler channelHandler = new SocketChannelHandler();

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new BytesToByteEncoder()});
        BeforeBytesDecoder beforeMessageDecoder = new BeforeBytesDecoder();
        beforeMessageDecoder.setHandler(this.splitMessageHandler);
        pipeline.addLast(new ChannelHandler[]{beforeMessageDecoder});
        pipeline.addLast(new ChannelHandler[]{new BytesToByteDecoder()});
        ChannelInboundHandler inboundHandler = new ChannelInboundHandler();
        inboundHandler.setChannelHandler(this.channelHandler);
        pipeline.addLast(new ChannelHandler[]{inboundHandler});
    }

    public void setSplitMessageHandler(SplitMessageHandler splitMessageHandler) {
        this.splitMessageHandler = splitMessageHandler;
    }

    public void setChannelHandler(SocketChannelHandler channelHandler) {
        this.channelHandler = channelHandler;
    }
}

