/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.netty.server.tcp;

import cn.foxtech.common.utils.netty.handler.SocketChannelHandler;
import cn.foxtech.common.utils.netty.server.tcp.NettyTcpChannelInitializer;
import cn.foxtech.device.protocol.v1.utils.netty.SplitMessageHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class NettyTcpServer {
    private ChannelInitializer channelInitializer;
    private ChannelFuture channelFuture;

    public static void createServer(int port, SplitMessageHandler splitMessageHandler, SocketChannelHandler channelHandler) {
        NettyTcpChannelInitializer channelInitializer = new NettyTcpChannelInitializer();
        channelInitializer.setChannelHandler(channelHandler);
        channelInitializer.setSplitMessageHandler(splitMessageHandler);
        NettyTcpServer.createServer(port, channelInitializer);
    }

    public static void createServer(final int port, final ChannelInitializer channelInitializer) {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    NettyTcpServer server = new NettyTcpServer();
                    server.setChannelInitializer(channelInitializer);
                    server.bind(port);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
        scheduledExecutorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(int port) {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            serverBootstrap = serverBootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup);
            serverBootstrap = (ServerBootstrap)serverBootstrap.channel(NioServerSocketChannel.class);
            serverBootstrap = (ServerBootstrap)serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(64, 10496, 0x100000));
            serverBootstrap = serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(64, 10496, 0x100000));
            serverBootstrap = serverBootstrap.childHandler((ChannelHandler)this.channelInitializer);
            System.out.println("netty server " + port + " start success!");
            this.channelFuture = serverBootstrap.bind(port).sync();
            this.channelFuture.channel().closeFuture().sync();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public ChannelInitializer getChannelInitializer() {
        return this.channelInitializer;
    }

    public void setChannelInitializer(ChannelInitializer channelInitializer) {
        this.channelInitializer = channelInitializer;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }
}

