/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.netty.handler;

import cn.foxtech.device.protocol.v1.utils.netty.SplitMessageHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class BeforeBytesDecoder
extends ByteToMessageDecoder {
    private SplitMessageHandler handler = new SplitMessageHandler();

    protected synchronized void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < this.handler.getHeaderLength()) {
            return;
        }
        in.markReaderIndex();
        int headerLength = this.handler.getHeaderLength();
        for (int index = 0; index < headerLength; ++index) {
            this.handler.setHeaderValue(index, in.readByte() & 0xFF);
        }
        in.resetReaderIndex();
        if (this.handler.isInvalidPack()) {
            ctx.close();
            return;
        }
        int packLen = this.handler.getPackLength();
        if (packLen == -1) {
            ctx.close();
        }
        if (in.readableBytes() < packLen) {
            return;
        }
        ByteBuf data = in.readBytes(packLen);
        out.add(data);
    }

    public void setHandler(SplitMessageHandler handler) {
        this.handler = handler;
    }
}

