/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.netty.client.tcp;

import cn.foxtech.common.utils.netty.client.tcp.NettyTcpClientInitializer;
import cn.foxtech.common.utils.netty.handler.SocketChannelHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class NettyTcpClientFactory {
    private static final NettyTcpClientFactory instance = new NettyTcpClientFactory();
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup group = new NioEventLoopGroup();
    private final NettyTcpClientInitializer channelInitializer = new NettyTcpClientInitializer();

    private NettyTcpClientFactory() {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).handler((ChannelHandler)this.channelInitializer);
    }

    public static NettyTcpClientFactory getInstance() {
        return instance;
    }

    public static void main(String[] args) {
        NettyTcpClientFactory inst = NettyTcpClientFactory.getInstance();
        inst.getChannelInitializer().setChannelHandler(new SocketChannelHandler());
        inst.createClient("127.0.0.1", 8080);
        inst.createClient("127.0.0.1", 8081);
        inst.createClient("127.0.0.1", 8082);
    }

    public ChannelFuture createClient(SocketAddress remoteAddress) {
        this.bootstrap.remoteAddress(remoteAddress);
        ChannelFuture channelFuture = this.bootstrap.connect().addListener(future -> {
            if (future.cause() != null) {
                // empty if block
            }
        });
        return channelFuture;
    }

    public ChannelFuture createClient(String host, int port) {
        InetSocketAddress remoteAddress = new InetSocketAddress(host, port);
        return this.createClient(remoteAddress);
    }

    public NettyTcpClientInitializer getChannelInitializer() {
        return this.channelInitializer;
    }
}

